/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;

public class SynchronizeCheckAdapter
extends RuleCheckAdapter {
    private int count;
    private int visitedCount;

    public SynchronizeCheckAdapter(ClassVisitor cv, TransformContext transformContext, int count) {
        super(cv, transformContext);
        this.count = count;
        this.visitedCount = 0;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matchTargetMethod(access, name, desc)) {
            this.setVisited();
            return new SynchronizeCheckMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class SynchronizeCheckMethodAdapter
    extends RuleCheckMethodAdapter {
        private int access;
        private String name;
        private String descriptor;
        private String signature;
        private String[] exceptions;
        private boolean visited;

        SynchronizeCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor);
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            SynchronizeCheckAdapter.this.visitedCount = 0;
        }

        @Override
        public void visitInsn(int opcode) {
            if (opcode == 194 && (SynchronizeCheckAdapter.this.count == 0 || SynchronizeCheckAdapter.this.visitedCount < SynchronizeCheckAdapter.this.count)) {
                SynchronizeCheckAdapter.this.visitedCount++;
                if (SynchronizeCheckAdapter.this.count == 0 || SynchronizeCheckAdapter.this.visitedCount == SynchronizeCheckAdapter.this.count) {
                    this.setTriggerPoint();
                }
            }
            super.visitInsn(opcode);
        }
    }
}

