/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.compiler;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.objectweb.asm.ClassWriter;
import org.jboss.byteman.objectweb.asm.FieldVisitor;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.objectweb.asm.Opcodes;
import org.jboss.byteman.objectweb.asm.Type;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;

public class Compiler
implements Opcodes {
    private static int nextId = 0;

    public static String getHelperAdapterName(Class helperClass, boolean compileToBytecode) {
        String helperName = Type.getInternalName(helperClass);
        if (compileToBytecode) {
            return helperName + "_HelperAdapter_Compiled_" + Compiler.nextId();
        }
        return helperName + "_HelperAdapter_Interpreted_" + Compiler.nextId();
    }

    public static Class getHelperAdapter(Rule rule, Class helperClass, String compiledHelperName, boolean compileToBytecode) throws CompileException {
        try {
            String helperName = Type.getInternalName(helperClass);
            byte[] classBytes = Compiler.compileBytes(rule, helperClass, helperName, compiledHelperName, compileToBytecode);
            String externalName = compiledHelperName.replace('/', '.');
            Transformer.maybeDumpClass(externalName, classBytes);
            ClassLoader loader = rule.getHelperLoader();
            return rule.getModuleSystem().loadHelperAdapter(loader, externalName, classBytes);
        }
        catch (CompileException ce) {
            throw ce;
        }
        catch (Throwable th) {
            if (compileToBytecode) {
                throw new CompileException("Compiler.createHelperAdapter : exception creating compiled helper adapter for " + helperClass.getName(), th);
            }
            throw new CompileException("Compiler.createHelperAdapter : exception creating interpreted helper adapter for " + helperClass.getName(), th);
        }
    }

    private static byte[] compileBytes(Rule rule, Class helperClass, String helperName, String compiledHelperName, boolean compileToBytecode) throws Exception {
        String ivarname;
        org.jboss.byteman.rule.type.Type type;
        String name;
        Binding binding;
        boolean superWantsRule;
        FieldVisitor fv;
        String name2;
        Binding binding2;
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 33, compiledHelperName, null, helperName, new String[]{"org/jboss/byteman/rule/helper/HelperAdapter"});
        String fullFileName = rule.getFile();
        int idx = fullFileName.lastIndexOf(File.separatorChar);
        String basicFileName = idx < 0 ? fullFileName : fullFileName.substring(idx + 1);
        String debug = "// compiled from: " + fullFileName + "\n// generated by Byteman\n";
        cw.visitSource(basicFileName, debug);
        Bindings bindings = rule.getBindings();
        Iterator<Binding> iterator22 = bindings.iterator();
        while (iterator22.hasNext()) {
            binding2 = iterator22.next();
            name2 = binding2.getIVarName();
            if (binding2.isAlias() || binding2.isHelper()) continue;
            org.jboss.byteman.rule.type.Type type2 = binding2.getType();
            if (rule.requiresAccess(type2)) {
                type2 = org.jboss.byteman.rule.type.Type.OBJECT;
            }
            fv = cw.visitField(2, name2, type2.getInternalName(true, true), null, null);
            fv.visitEnd();
        }
        fv = cw.visitField(2, "rule", "Lorg/jboss/byteman/rule/Rule;", "Lorg/jboss/byteman/rule/Rule;", null);
        fv.visitEnd();
        Constructor superConstructor = null;
        try {
            superConstructor = helperClass.getDeclaredConstructor(Rule.class);
        }
        catch (NoSuchMethodException iterator22) {
        }
        catch (SecurityException e) {
            throw new CompileException("Compiler.compileBytes : unable to access constructor for helper class " + helperClass.getCanonicalName());
        }
        boolean bl = superWantsRule = superConstructor != null;
        if (!superWantsRule) {
            try {
                superConstructor = helperClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new CompileException("Compiler.compileBytes : no valid constructor found for helper class " + helperClass.getCanonicalName());
            }
            catch (SecurityException e) {
                throw new CompileException("Compiler.compileBytes : unable to access constructor for helper class " + helperClass.getCanonicalName());
            }
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lorg/jboss/byteman/rule/Rule;)V", null, null);
        CompileContext cc = new CompileContext(mv);
        cc.addLocalCount(2);
        mv.visitCode();
        if (superWantsRule) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            cc.addStackCount(2);
            mv.visitMethodInsn(183, helperName, "<init>", "(Lorg/jboss/byteman/rule/Rule;)V");
            cc.addStackCount(-2);
        } else {
            mv.visitVarInsn(25, 0);
            cc.addStackCount(1);
            mv.visitMethodInsn(183, helperName, "<init>", "()V");
            cc.addStackCount(-1);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        cc.addStackCount(2);
        mv.visitFieldInsn(181, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        cc.addStackCount(-2);
        mv.visitInsn(177);
        mv.visitMaxs(cc.getStackMax(), cc.getLocalMax());
        mv.visitEnd();
        mv = cw.visitMethod(1, "execute", "(Ljava/lang/Object;[Ljava/lang/Object;)V", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
        cc = new CompileContext(mv);
        cc.addLocalCount(3);
        mv.visitCode();
        mv.visitMethodInsn(184, "org/jboss/byteman/agent/Transformer", "isVerbose", "()Z");
        cc.addStackCount(1);
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        cc.addStackCount(-1);
        mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        cc.addStackCount(1);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        cc.addStackCount(1);
        mv.visitInsn(89);
        cc.addStackCount(1);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
        cc.addStackCount(-1);
        mv.visitVarInsn(25, 0);
        cc.addStackCount(1);
        mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getName", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        cc.addStackCount(-1);
        mv.visitLdcInsn(" execute()");
        cc.addStackCount(1);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        cc.addStackCount(-1);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        cc.addStackCount(-2);
        if (cc.getStackCount() != 0) {
            throw new RuntimeException("Compiler.compileBytes: unexpected stack count " + cc.getStackCount());
        }
        mv.visitLabel(l0);
        Bindings bindings2 = rule.getBindings();
        Iterator<Binding> iterator = bindings2.iterator();
        while (iterator.hasNext()) {
            binding = iterator.next();
            if (binding.isAlias()) continue;
            name = binding.getIVarName();
            if (!binding.isHelper()) {
                org.jboss.byteman.rule.type.Type type3;
                if (binding.isRecipient()) {
                    mv.visitVarInsn(25, 0);
                    mv.visitVarInsn(25, 1);
                    cc.addStackCount(2);
                    type3 = binding.getType();
                    if (rule.requiresAccess(type3)) {
                        type3 = org.jboss.byteman.rule.type.Type.OBJECT;
                    } else {
                        cc.compileTypeConversion(org.jboss.byteman.rule.type.Type.OBJECT, type3);
                    }
                    mv.visitFieldInsn(181, compiledHelperName, name, type3.getInternalName(true, true));
                    cc.addStackCount(-2);
                } else if (!binding.isBindVar()) {
                    mv.visitVarInsn(25, 0);
                    mv.visitVarInsn(25, 2);
                    mv.visitLdcInsn(binding.getCallArrayIndex());
                    cc.addStackCount(3);
                    mv.visitInsn(50);
                    cc.addStackCount(-1);
                    type3 = binding.getType();
                    if (rule.requiresAccess(type3)) {
                        type3 = org.jboss.byteman.rule.type.Type.OBJECT;
                    } else {
                        cc.compileTypeConversion(org.jboss.byteman.rule.type.Type.OBJECT, type3);
                    }
                    mv.visitFieldInsn(181, compiledHelperName, name, type3.getInternalName(true, true));
                    if (type3.getNBytes() > 4) {
                        cc.addStackCount(-3);
                    } else {
                        cc.addStackCount(-2);
                    }
                }
            }
            if (cc.getStackCount() == 0) continue;
            throw new RuntimeException("Compiler.compileBytes: unexpected stack count " + cc.getStackCount());
        }
        mv.visitVarInsn(25, 0);
        cc.addStackCount(1);
        mv.visitMethodInsn(182, compiledHelperName, "execute0", "()V");
        cc.addStackCount(-1);
        iterator = bindings2.iterator();
        while (iterator.hasNext()) {
            binding = iterator.next();
            if (binding.isAlias()) continue;
            name = binding.getIVarName();
            if (binding.isUpdated() && !binding.isBindVar()) {
                int idx2 = binding.getCallArrayIndex();
                mv.visitVarInsn(25, 2);
                mv.visitLdcInsn(idx2);
                mv.visitVarInsn(25, 0);
                cc.addStackCount(3);
                type = binding.getType();
                if (rule.requiresAccess(type)) {
                    type = org.jboss.byteman.rule.type.Type.OBJECT;
                }
                mv.visitFieldInsn(180, compiledHelperName, name, type.getInternalName(true, true));
                if (type.getNBytes() > 4) {
                    cc.addStackCount(1);
                }
                cc.compileTypeConversion(type, org.jboss.byteman.rule.type.Type.OBJECT);
                mv.visitInsn(83);
                cc.addStackCount(-3);
            }
            if (cc.getStackCount() == 0) continue;
            throw new RuntimeException("Compiler.compileBytes: unexpected stack count " + cc.getStackCount());
        }
        mv.visitInsn(177);
        mv.visitMaxs(cc.getStackMax(), cc.getLocalMax());
        mv.visitEnd();
        mv = cw.visitMethod(1, "setBinding", "(Ljava/lang/String;Ljava/lang/Object;)V", null, null);
        cc = new CompileContext(mv);
        cc.addLocalCount(3);
        mv.visitCode();
        bindings = rule.getBindings();
        Iterator<Binding> iterator3 = bindings.iterator();
        while (iterator3.hasNext()) {
            binding2 = iterator3.next();
            if (binding2.isAlias()) continue;
            name2 = binding2.getName();
            ivarname = binding2.getIVarName();
            if (!binding2.isHelper() && !binding2.isAlias()) {
                Label skip = new Label();
                mv.visitLdcInsn(name2);
                mv.visitVarInsn(25, 1);
                cc.addStackCount(2);
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
                cc.addStackCount(-1);
                mv.visitJumpInsn(153, skip);
                cc.addStackCount(-1);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 2);
                cc.addStackCount(2);
                type = binding2.getType();
                if (rule.requiresAccess(type)) {
                    type = org.jboss.byteman.rule.type.Type.OBJECT;
                } else {
                    cc.compileTypeConversion(org.jboss.byteman.rule.type.Type.OBJECT, type);
                }
                mv.visitFieldInsn(181, compiledHelperName, ivarname, type.getInternalName(true, true));
                if (type.getNBytes() > 4) {
                    cc.addStackCount(-3);
                } else {
                    cc.addStackCount(-2);
                }
                mv.visitLabel(skip);
            }
            if (cc.getStackCount() == 0) continue;
            throw new RuntimeException("Compiler.compileBytes: unexpected stack count " + cc.getStackCount());
        }
        mv.visitInsn(177);
        mv.visitMaxs(cc.getStackMax(), cc.getLocalMax());
        mv.visitEnd();
        mv = cw.visitMethod(1, "getBinding", "(Ljava/lang/String;)Ljava/lang/Object;", null, null);
        cc = new CompileContext(mv);
        cc.addLocalCount(2);
        mv.visitCode();
        bindings = rule.getBindings();
        iterator3 = bindings.iterator();
        while (iterator3.hasNext()) {
            Label skip;
            binding2 = iterator3.next();
            name2 = binding2.getName();
            ivarname = binding2.getIVarName();
            if (binding2.isAlias()) continue;
            if (binding2.isHelper()) {
                skip = new Label();
                mv.visitLdcInsn(name2);
                mv.visitVarInsn(25, 1);
                cc.addStackCount(2);
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
                cc.addStackCount(-1);
                mv.visitJumpInsn(153, skip);
                cc.addStackCount(-1);
                mv.visitVarInsn(25, 0);
                cc.addStackCount(1);
                mv.visitInsn(176);
                cc.addStackCount(-1);
                mv.visitLabel(skip);
            } else {
                skip = new Label();
                mv.visitLdcInsn(name2);
                mv.visitVarInsn(25, 1);
                cc.addStackCount(2);
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
                cc.addStackCount(-1);
                mv.visitJumpInsn(153, skip);
                cc.addStackCount(-1);
                mv.visitVarInsn(25, 0);
                cc.addStackCount(1);
                type = binding2.getType();
                if (rule.requiresAccess(type)) {
                    type = org.jboss.byteman.rule.type.Type.OBJECT;
                }
                mv.visitFieldInsn(180, compiledHelperName, ivarname, type.getInternalName(true, true));
                if (type.getNBytes() > 4) {
                    cc.addStackCount(1);
                }
                cc.compileTypeConversion(type, org.jboss.byteman.rule.type.Type.OBJECT);
                mv.visitInsn(176);
                cc.addStackCount(-1);
                mv.visitLabel(skip);
            }
            if (cc.getStackCount() == 0) continue;
            throw new RuntimeException("Compiler.compileBytes: unexpected stack count " + cc.getStackCount());
        }
        mv.visitInsn(1);
        cc.addStackCount(1);
        mv.visitInsn(176);
        cc.addStackCount(-1);
        if (cc.getStackCount() != 0) {
            throw new RuntimeException("Compiler.compileBytes: unexpected stack count " + cc.getStackCount());
        }
        mv.visitMaxs(cc.getStackMax(), cc.getLocalMax());
        mv.visitEnd();
        mv = cw.visitMethod(1, "getName", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getName", "()Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getAccessibleField", "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getAccessibleField", "(Ljava/lang/Object;I)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setAccessibleField", "(Ljava/lang/Object;Ljava/lang/Object;I)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(21, 3);
        mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "setAccessibleField", "(Ljava/lang/Object;Ljava/lang/Object;I)V");
        mv.visitInsn(177);
        mv.visitMaxs(4, 4);
        mv.visitEnd();
        mv = cw.visitMethod(1, "invokeAccessibleMethod", "(Ljava/lang/Object;[Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(21, 3);
        mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "invokeAccessibleMethod", "(Ljava/lang/Object;[Ljava/lang/Object;I)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(4, 4);
        mv.visitEnd();
        if (compileToBytecode) {
            mv = cw.visitMethod(2, "execute0", "()V", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
            mv.visitCode();
            cc = new CompileContext(mv);
            cc.notifySourceLine(rule.getLine());
            cc.addLocalCount(3);
            rule.getEvent().compile(mv, cc);
            rule.getCondition().compile(mv, cc);
            l0 = new Label();
            mv.visitJumpInsn(153, l0);
            cc.addStackCount(-1);
            rule.getAction().compile(mv, cc);
            mv.visitLabel(l0);
            cc.notifySourceEnd();
            mv.visitInsn(177);
            mv.visitMaxs(cc.getStackMax(), cc.getLocalMax());
            mv.visitEnd();
        } else {
            mv = cw.visitMethod(2, "execute0", "()V", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, compiledHelperName, "bind", "()V");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, compiledHelperName, "test", "()Z");
            l0 = new Label();
            mv.visitJumpInsn(153, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, compiledHelperName, "fire", "()V");
            mv.visitLabel(l0);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            mv = cw.visitMethod(2, "bind", "()V", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getEvent", "()Lorg/jboss/byteman/rule/Event;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Event", "interpret", "(Lorg/jboss/byteman/rule/helper/HelperAdapter;)Ljava/lang/Object;");
            mv.visitInsn(177);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
            mv = cw.visitMethod(2, "test", "()Z", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getCondition", "()Lorg/jboss/byteman/rule/Condition;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Condition", "interpret", "(Lorg/jboss/byteman/rule/helper/HelperAdapter;)Ljava/lang/Object;");
            mv.visitTypeInsn(192, "java/lang/Boolean");
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            mv.visitInsn(172);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
            mv = cw.visitMethod(2, "fire", "()V", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getAction", "()Lorg/jboss/byteman/rule/Action;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Action", "interpret", "(Lorg/jboss/byteman/rule/helper/HelperAdapter;)Ljava/lang/Object;");
            mv.visitInsn(177);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static synchronized int nextId() {
        return ++nextId;
    }
}

