/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.AssignableExpression;
import org.jboss.byteman.rule.expression.BinaryOperExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.Variable;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class AssignExpression
extends BinaryOperExpression {
    private AssignableExpression lhs;

    public AssignExpression(Rule rule, ParseNode token, AssignableExpression left, Expression right) {
        super(rule, 9217, Type.UNDEFINED, token, left, right);
        this.lhs = left;
    }

    @Override
    public void bind() throws TypeException {
        this.lhs.bindAssign();
        this.getOperand(1).bind();
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Expression rhs = this.getOperand(1);
        if ((expected.isUndefined() || expected.isVoid()) && this.lhs instanceof Variable) {
            Type type1 = this.lhs.typeCheckAssign(Type.UNDEFINED);
            Type type2 = rhs.typeCheck(type1);
            this.type = type1;
        } else {
            Type type1;
            Type type2 = rhs.typeCheck(expected);
            this.type = type1 = this.lhs.typeCheckAssign(type2);
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        Object value = this.getOperand(1).interpret(helper);
        value = this.lhs.interpretAssign(helper, value);
        return value;
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        Expression oper1 = this.getOperand(1);
        int currentStack = compileContext.getStackCount();
        int expected = this.type.getNBytes() > 4 ? 2 : 1;
        oper1.compile(mv, compileContext);
        Type rhsType = oper1.getType();
        Type lhsType = this.type;
        if (!this.rule.requiresAccess(lhsType)) {
            if (this.rule.requiresAccess(rhsType)) {
                rhsType = Type.OBJECT;
            }
            compileContext.compileTypeConversion(rhsType, lhsType);
        }
        this.lhs.compileAssign(mv, compileContext);
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("AssignExpression.compileAssignment : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
    }
}

