/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.BinaryOperExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class BitExpression
extends BinaryOperExpression {
    public BitExpression(Rule rule, int oper, ParseNode token, Expression left, Expression right) throws TypeException {
        super(rule, oper, Type.promote(left.getType(), right.getType()), token, left, right);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        block5: {
            block6: {
                Type type2;
                Type type1;
                block4: {
                    type1 = this.getOperand(0).typeCheck(Type.N);
                    type2 = this.getOperand(1).typeCheck(Type.N);
                    this.type = Type.promote(type1, type2);
                    if (!this.type.isFloating()) break block4;
                    this.type = Type.J;
                    break block5;
                }
                if (type1 == Type.C) break block6;
                if (type2 != Type.C) break block5;
            }
            throw new TypeException("BitExpression.typeCheck : invalid operand type java.lang.character " + this.getPos());
        }
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("BitExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            int result;
            Number value1 = (Number)this.getOperand(0).interpret(helper);
            Number value2 = (Number)this.getOperand(1).interpret(helper);
            if (this.type == Type.B) {
                byte result2;
                byte b1 = value1.byteValue();
                byte b2 = value2.byteValue();
                switch (this.oper) {
                    case 8448: {
                        result2 = (byte)(b1 | b2);
                        break;
                    }
                    case 8449: {
                        result2 = (byte)(b1 & b2);
                        break;
                    }
                    case 8450: {
                        result2 = (byte)(b1 ^ b2);
                        break;
                    }
                    default: {
                        result2 = 0;
                    }
                }
                return result2;
            }
            if (this.type == Type.S) {
                short result3;
                short s1 = value1.shortValue();
                short s2 = value2.shortValue();
                switch (this.oper) {
                    case 8448: {
                        result3 = (short)(s1 | s2);
                        break;
                    }
                    case 8449: {
                        result3 = (short)(s1 & s2);
                        break;
                    }
                    case 8450: {
                        result3 = (short)(s1 ^ s2);
                        break;
                    }
                    default: {
                        result3 = 0;
                    }
                }
                return result3;
            }
            if (this.type == Type.I) {
                int result4;
                int i1 = value1.intValue();
                int i2 = value2.intValue();
                switch (this.oper) {
                    case 8448: {
                        result4 = i1 | i2;
                        break;
                    }
                    case 8449: {
                        result4 = i1 & i2;
                        break;
                    }
                    case 8450: {
                        result4 = i1 ^ i2;
                        break;
                    }
                    default: {
                        result4 = 0;
                    }
                }
                return result4;
            }
            if (this.type == Type.J) {
                long result5;
                long l1 = value1.longValue();
                long l2 = value2.longValue();
                switch (this.oper) {
                    case 8448: {
                        result5 = l1 | l2;
                        break;
                    }
                    case 8449: {
                        result5 = l1 & l2;
                        break;
                    }
                    case 8450: {
                        result5 = l1 ^ l2;
                        break;
                    }
                    default: {
                        result5 = 0L;
                    }
                }
                return result5;
            }
            int s1 = value1.intValue();
            int s2 = value2.intValue();
            switch (this.oper) {
                case 8448: {
                    result = (char)(s1 | s2);
                    break;
                }
                case 8449: {
                    result = (char)(s1 & s2);
                    break;
                }
                case 8450: {
                    result = (char)(s1 ^ s2);
                    break;
                }
                default: {
                    result = 0;
                }
            }
            return result;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException("BitExpression.interpret : unexpected exception for operation " + this.token + this.getPos() + " in rule " + helper.getName(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        int currentStack = compileContext.getStackCount();
        int expected = 0;
        Expression oper0 = this.getOperand(0);
        Expression oper1 = this.getOperand(1);
        oper0.compile(mv, compileContext);
        compileContext.compileTypeConversion(oper0.getType(), this.type);
        oper1.compile(mv, compileContext);
        compileContext.compileTypeConversion(oper1.getType(), this.type);
        if (this.type == Type.B || this.type == Type.S || this.type == Type.I) {
            switch (this.oper) {
                case 8448: {
                    mv.visitInsn(128);
                    break;
                }
                case 8449: {
                    mv.visitInsn(126);
                    break;
                }
                case 8450: {
                    mv.visitInsn(130);
                }
            }
            if (this.type == Type.B) {
                mv.visitInsn(145);
            } else if (this.type == Type.S) {
                mv.visitInsn(147);
            } else if (this.type == Type.C) {
                mv.visitInsn(146);
            }
            compileContext.addStackCount(-2);
            expected = 1;
        } else if (this.type == Type.J) {
            switch (this.oper) {
                case 8448: {
                    mv.visitInsn(129);
                    break;
                }
                case 8449: {
                    mv.visitInsn(127);
                    break;
                }
                case 8450: {
                    mv.visitInsn(131);
                }
            }
            compileContext.addStackCount(-2);
            expected = 2;
        }
        compileContext.addStackCount(expected);
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("BitExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack + expected);
        }
    }
}

