/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.ThrowException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.exception.TypeWarningException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;
import org.jboss.byteman.rule.type.TypeHelper;

public class ThrowExpression
extends Expression {
    private String typeName;
    private List<Expression> arguments;
    private List<Type> argumentTypes;
    private List<Type> paramTypes;
    private Constructor constructor;

    public ThrowExpression(Rule rule, ParseNode token, List<Expression> arguments) {
        super(rule, Type.UNDEFINED, token);
        this.typeName = token.getText();
        this.arguments = arguments;
        this.argumentTypes = null;
        this.constructor = null;
    }

    @Override
    public void bind() throws TypeException {
        Iterator<Expression> iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            iterator.next().bind();
        }
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        TypeGroup typeGroup = this.getTypeGroup();
        this.type = Type.dereference(typeGroup.create(this.typeName));
        if (this.type == null || this.type.isUndefined()) {
            throw new TypeException("ThrowExpression.typeCheck : unknown exception type " + this.typeName + this.getPos());
        }
        if (!Throwable.class.isAssignableFrom(this.type.getTargetClass())) {
            throw new TypeException("ThrowExpression.typeCheck : not an exception type " + this.typeName + this.getPos());
        }
        Class clazz = this.type.getTargetClass();
        int arity = this.arguments.size();
        Constructor<?>[] constructors = clazz.getConstructors();
        List<Constructor> candidates = new ArrayList<Constructor>();
        boolean duplicates = false;
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length != arity) continue;
            candidates.add(constructor);
        }
        this.argumentTypes = new ArrayList<Type>();
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (candidates.isEmpty()) {
                throw new TypeException("ThrowExpression.typeCheck : invalid constructor for target class " + this.typeName + this.getPos());
            }
            Class candidateClass = this.getCandidateArgClass(candidates, i);
            Type candidateType = candidateClass != null ? typeGroup.ensureType(candidateClass) : Type.UNDEFINED;
            Type argType = this.arguments.get(i).typeCheck(candidateType);
            this.argumentTypes.add(argType);
            if (candidateType != Type.UNDEFINED) continue;
            candidates = this.pruneCandidates(candidates, i, argType.getTargetClass());
        }
        if (candidates.isEmpty()) {
            throw new TypeException("ThrowExpression.typeCheck : invalid constructor for target class " + this.typeName + this.getPos());
        }
        if (candidates.size() > 1) {
            throw new TypeException("ThrowExpression.typeCheck : ambiguous constructor signature for target class " + this.typeName + this.getPos());
        }
        this.constructor = (Constructor)candidates.get(0);
        this.paramTypes = new ArrayList<Type>();
        Class<?>[] paramClasses = this.constructor.getParameterTypes();
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.paramTypes.add(typeGroup.ensureType(paramClasses[i]));
        }
        this.checkThrownTypeIsValid();
        return this.type;
    }

    public Class getCandidateArgClass(List<Constructor> candidates, int argIdx) {
        Class<?> argClazz = null;
        for (Constructor c : candidates) {
            Class<?> nextClazz = c.getParameterTypes()[argIdx];
            if (argClazz == null) {
                argClazz = nextClazz;
                continue;
            }
            if (argClazz == nextClazz) continue;
            return null;
        }
        return argClazz;
    }

    public List<Constructor> pruneCandidates(List<Constructor> candidates, int argIdx, Class argClazz) {
        int i = 0;
        while (i < candidates.size()) {
            Constructor c = candidates.get(i);
            Class<?> nextClazz = c.getParameterTypes()[argIdx];
            if (nextClazz != argClazz) {
                candidates.remove(i);
                continue;
            }
            ++i;
        }
        return candidates;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        int l = this.arguments.size();
        Object[] callArgs = new Object[l];
        for (int i = 0; i < l; ++i) {
            callArgs[i] = this.arguments.get(i).interpret(helper);
        }
        try {
            Throwable th = (Throwable)this.constructor.newInstance(callArgs);
            ThrowException thex = new ThrowException(th);
            throw thex;
        }
        catch (InstantiationException e) {
            throw new ExecuteException("ThrowExpression.interpret : unable to instantiate exception class " + this.typeName + this.getPos(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExecuteException("ThrowExpression.interpret : unable to access exception class " + this.typeName + this.getPos(), e);
        }
        catch (InvocationTargetException e) {
            throw new ExecuteException("ThrowExpression.interpret : unable to invoke exception class constructor for " + this.typeName + this.getPos(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        int currentStack = compileContext.getStackCount();
        int expected = 1;
        int extraParams = 0;
        String exceptionClassName = this.type.getInternalName();
        mv.visitTypeInsn(187, exceptionClassName);
        compileContext.addStackCount(1);
        mv.visitInsn(89);
        compileContext.addStackCount(1);
        int argCount = this.arguments.size();
        for (int i = 0; i < argCount; ++i) {
            Type argType = this.argumentTypes.get(i);
            Type paramType = this.paramTypes.get(i);
            int paramCount = paramType.getNBytes() > 4 ? 2 : 1;
            extraParams += paramCount;
            this.arguments.get(i).compile(mv, compileContext);
            compileContext.compileTypeConversion(argType, paramType);
        }
        mv.visitMethodInsn(183, exceptionClassName, "<init>", this.getDescriptor());
        compileContext.addStackCount(-(extraParams + 1));
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("ThrowExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
        exceptionClassName = "org/jboss/byteman/rule/exception/ThrowException";
        mv.visitTypeInsn(187, exceptionClassName);
        compileContext.addStackCount(1);
        mv.visitInsn(90);
        compileContext.addStackCount(1);
        mv.visitInsn(95);
        mv.visitMethodInsn(183, exceptionClassName, "<init>", "(Ljava/lang/Throwable;)V");
        compileContext.addStackCount(-2);
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("ThrowExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
        mv.visitInsn(191);
        compileContext.addStackCount(-1);
    }

    private String getDescriptor() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        int nParams = this.paramTypes.size();
        for (int i = 0; i < nParams; ++i) {
            buffer.append(this.paramTypes.get(i).getInternalName(true, true));
        }
        buffer.append(")V");
        return buffer.toString();
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write("throw ");
        if (this.type == null || Type.UNDEFINED == this.type) {
            stringWriter.write(this.typeName);
        } else {
            stringWriter.write(this.type.getName());
        }
        String separator = "";
        stringWriter.write("(");
        for (Expression argument : this.arguments) {
            stringWriter.write(separator);
            argument.writeTo(stringWriter);
            separator = ",";
        }
        stringWriter.write(")");
    }

    private void checkThrownTypeIsValid() throws TypeWarningException, TypeException {
        TypeGroup typeGroup = this.getTypeGroup();
        if (RuntimeException.class.isAssignableFrom(this.type.getTargetClass())) {
            return;
        }
        if (Error.class.isAssignableFrom(this.type.getTargetClass())) {
            return;
        }
        for (Type exceptionType : typeGroup.getExceptionTypes()) {
            if (!Type.dereference(exceptionType).isAssignableFrom(this.type)) continue;
            return;
        }
        ClassLoader loader = this.rule.getLoader();
        String targetClassName = this.rule.getTargetClass();
        String triggerClassName = this.rule.getTriggerClass();
        String triggerMethodName = this.rule.getTriggerMethod();
        String descriptor = this.rule.getTriggerDescriptor();
        Class<?>[] paramTypes = null;
        boolean isQualified = targetClassName.contains(".");
        boolean isClass = !this.rule.isInterface();
        try {
            Class<?> triggerClass = loader.loadClass(triggerClassName);
            SuperIterator superIterator = isClass ? new ClassIterator(triggerClass.getSuperclass()) : new InterfaceIterator(triggerClass);
            while (superIterator.hasNext()) {
                Class nextClass = (Class)superIterator.next();
                String nextClassName = nextClass.getName();
                if (!nextClassName.equals(targetClassName) && (isQualified || !nextClassName.endsWith("." + targetClassName))) continue;
                if (paramTypes == null) {
                    paramTypes = this.createParamTypes(descriptor, loader);
                }
                try {
                    Method method = nextClass.getMethod(triggerMethodName, paramTypes);
                    Class<?>[] exceptionTypes = method.getExceptionTypes();
                    for (int i = 0; i < exceptionTypes.length; ++i) {
                        if (!exceptionTypes[i].isAssignableFrom(this.type.getTargetClass())) continue;
                        throw new TypeWarningException("ThrowExpression.typeCheck : exception type declared by rule target method but not by trigger method " + this.typeName + this.getPos());
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new TypeException("ThrowExpression.typeCheck : exception type not declared by trigger method " + this.typeName + this.getPos());
    }

    public Class<?>[] createParamTypes(String descriptor, ClassLoader loader) throws TypeException {
        String external = TypeHelper.parseMethodDescriptor(descriptor).substring(1);
        String typeNamesOnly = external.substring(0, external.indexOf(")")).trim();
        if (typeNamesOnly.length() == 0) {
            return new Class[0];
        }
        String[] typeNameList = typeNamesOnly.split(",");
        Class[] classList = new Class[typeNameList.length];
        for (int i = 0; i < typeNameList.length; ++i) {
            String name = typeNameList[i].trim();
            try {
                classList[i] = loader.loadClass(name);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new TypeException("ThrowExpression.createParamTypes : unexpected error looking up trigger method parameter type" + e);
            }
        }
        return classList;
    }

    public class InterfaceIterator
    extends SuperIterator {
        private LinkedList<Class<?>> visited;
        private LinkedList<Class<?>> unvisited;
        private Class<?> nextClass;

        public InterfaceIterator(Class<?> startClass) {
            this.visited = new LinkedList();
            this.unvisited = new LinkedList();
            this.nextClass = startClass;
        }

        private void pushInterfaces() {
            if (this.nextClass != null) {
                LinkedList candidates = new LinkedList();
                Class<?>[] ifaces = this.nextClass.getInterfaces();
                for (int i = 0; i < ifaces.length; ++i) {
                    candidates.add(ifaces[i]);
                }
                while (!candidates.isEmpty()) {
                    Class iface = (Class)candidates.pop();
                    if (this.visited.contains(iface) || this.unvisited.contains(iface)) continue;
                    this.unvisited.add(iface);
                    ifaces = iface.getInterfaces();
                    for (int i = 0; i < ifaces.length; ++i) {
                        candidates.add(ifaces[i]);
                    }
                }
                this.nextClass = this.nextClass.getSuperclass();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.unvisited.isEmpty()) {
                this.pushInterfaces();
            }
            return !this.unvisited.isEmpty();
        }

        @Override
        public Class<?> next() {
            Class<?> next = this.unvisited.pop();
            this.visited.add(next);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class ClassIterator
    extends SuperIterator {
        private Class<?> nextClass;

        public ClassIterator(Class<?> startClass) {
            this.nextClass = startClass;
        }

        @Override
        public boolean hasNext() {
            return this.nextClass != null;
        }

        @Override
        public Class<?> next() {
            Class<?> next = this.nextClass;
            this.nextClass = this.nextClass.getSuperclass();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public abstract class SuperIterator
    implements Iterator<Class<?>> {
    }
}

