/*
 * Decompiled with CFR 0.152.
 */
package io.orangebuffalo.testcontainers.playwright;

import io.orangebuffalo.testcontainers.playwright.ContainerApi;
import io.orangebuffalo.testcontainers.playwright.PlaywrightApi;
import io.orangebuffalo.testcontainers.playwright.PlaywrightApiManager;
import io.orangebuffalo.testcontainers.playwright.PlaywrightContainer;
import io.orangebuffalo.testcontainers.playwright.PlaywrightContainerKt;
import io.orangebuffalo.testcontainers.playwright.PlaywrightUtilsKt;
import io.orangebuffalo.testcontainers.playwright.shadow.kotlinx.serialization.DeserializationStrategy;
import io.orangebuffalo.testcontainers.playwright.shadow.kotlinx.serialization.SerializationStrategy;
import io.orangebuffalo.testcontainers.playwright.shadow.kotlinx.serialization.json.Json;
import io.orangebuffalo.testcontainers.playwright.shadow.kotlinx.serialization.json.JsonKt;
import io.orangebuffalo.testcontainers.playwright.shadow.org.jetbrains.annotations.NotNull;
import io.orangebuffalo.testcontainers.playwright.shadow.org.jetbrains.annotations.Nullable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\r\u0010\u0015\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\r\u0010\u001b\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/orangebuffalo/testcontainers/playwright/PlaywrightContainer;", "Lorg/testcontainers/containers/GenericContainer;", "customImage", "Lorg/testcontainers/utility/DockerImageName;", "(Lorg/testcontainers/utility/DockerImageName;)V", "apiManager", "Lio/orangebuffalo/testcontainers/playwright/PlaywrightApiManager;", "chromiumWsEndpoint", "", "firefoxWsEndpoint", "json", "Lio/orangebuffalo/testcontainers/playwright/shadow/kotlinx/serialization/json/Json;", "playwrightVersion", "playwrightVersionCompatibleTag", "webkitWsEndpoint", "close", "", "configure", "createBrowserAndGetWsEndpoint", "params", "Lio/orangebuffalo/testcontainers/playwright/ContainerApi$LaunchRequest;", "getChromiumWsEndpoint", "getChromiumWsEndpoint$testcontainers_playwright", "getFirefoxWsEndpoint", "getFirefoxWsEndpoint$testcontainers_playwright", "getPlaywrightApi", "Lio/orangebuffalo/testcontainers/playwright/PlaywrightApi;", "getWebkitWsEndpoint", "getWebkitWsEndpoint$testcontainers_playwright", "start", "testcontainers-playwright"})
public final class PlaywrightContainer
extends GenericContainer<PlaywrightContainer> {
    @Nullable
    private final DockerImageName customImage;
    @Nullable
    private final String playwrightVersion;
    @Nullable
    private final String playwrightVersionCompatibleTag;
    @NotNull
    private final Json json;
    @Nullable
    private String chromiumWsEndpoint;
    @Nullable
    private String firefoxWsEndpoint;
    @Nullable
    private String webkitWsEndpoint;
    @NotNull
    private final PlaywrightApiManager apiManager;

    /*
     * WARNING - void declaration
     */
    public PlaywrightContainer(@Nullable DockerImageName customImage) {
        super(DockerImageName.parse((String)"ghcr.io/orange-buffalo/testcontainers-playwright:1.31"));
        String string;
        String[] stringArray;
        this.customImage = customImage;
        this.playwrightVersion = PlaywrightUtilsKt.getPlaywrightVersionOnClasspath();
        PlaywrightContainer playwrightContainer = this;
        Object object = this.playwrightVersion;
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{"."}), (boolean)false, (int)0, (int)6, null)) != null) {
            void parts;
            Object object2 = object;
            PlaywrightContainer playwrightContainer2 = playwrightContainer;
            boolean bl = false;
            string = parts.size() >= 2 ? parts.get(0) + "." + parts.get(1) : this.playwrightVersion;
            playwrightContainer = playwrightContainer2;
        } else {
            string = null;
        }
        playwrightContainer.playwrightVersionCompatibleTag = string;
        this.json = JsonKt.Json$default(null, json.1.INSTANCE, 1, null);
        this.apiManager = new PlaywrightApiManager(this);
    }

    public /* synthetic */ PlaywrightContainer(DockerImageName dockerImageName, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerImageName = null;
        }
        this(dockerImageName);
    }

    @NotNull
    public final PlaywrightApi getPlaywrightApi() {
        return this.apiManager.getPlaywrightApi();
    }

    protected void configure() {
        if (this.playwrightVersion == null && this.customImage == null) {
            throw new IllegalArgumentException("Playwright version could not be detected on classpath and image was not specified. Please ensure Playwright is present on classpath or provide a particular image of testcontainers-playwright Docker image that is compatible with your code.");
        }
        this.withCopyToContainer((Transferable)MountableFile.forClasspathResource((String)"playwright-server.js"), "/app/playwright-server.js");
        if (this.customImage == null) {
            PlaywrightContainerKt.access$getLog$p().info((Function0<? extends Object>)((Function0)new Function0<Object>(this){
                final /* synthetic */ PlaywrightContainer this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Will use Playwright image " + PlaywrightContainer.access$getPlaywrightVersionCompatibleTag$p(this.this$0) + " for version " + PlaywrightContainer.access$getPlaywrightVersion$p(this.this$0) + " found on classpath";
                }
            }));
            super.setDockerImageName("ghcr.io/orange-buffalo/testcontainers-playwright:" + this.playwrightVersionCompatibleTag);
        }
        Object[] objectArray = new Integer[]{3000, 4444, 4445, 4446};
        this.withExposedPorts((Integer[])objectArray);
        this.waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx("Server running at .*"));
        objectArray = new String[]{"node", "/app/playwright-server.js"};
        this.withCommand((String[])objectArray);
    }

    public void start() {
        String string;
        super.start();
        try {
            string = (String)this.copyFileFromContainer("/app/version.txt", PlaywrightContainer::start$lambda$1);
        }
        catch (Exception e) {
            PlaywrightContainerKt.access$getLog$p().warn(e, (Function0<? extends Object>)((Function0)start.versionInContainer.2.INSTANCE));
            string = null;
        }
        String versionInContainer2 = string;
        if (this.customImage != null && !Intrinsics.areEqual((Object)versionInContainer2, (Object)this.playwrightVersionCompatibleTag)) {
            PlaywrightContainerKt.access$getLog$p().warn((Function0<? extends Object>)((Function0)new Function0<Object>(versionInContainer2, this){
                final /* synthetic */ String $versionInContainer;
                final /* synthetic */ PlaywrightContainer this$0;
                {
                    this.$versionInContainer = $versionInContainer;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Playwright version in container (" + this.$versionInContainer + ") is not compatible with Playwright on the classpath (" + PlaywrightContainer.access$getPlaywrightVersion$p(this.this$0) + "). This might lead to unexpected results, for instance browser being started locally instead of in container.";
                }
            }));
        }
    }

    public void close() {
        this.apiManager.close();
        super.close();
    }

    @NotNull
    public final synchronized String getChromiumWsEndpoint$testcontainers_playwright() {
        if (this.chromiumWsEndpoint == null) {
            this.chromiumWsEndpoint = this.createBrowserAndGetWsEndpoint(new ContainerApi.LaunchRequest(ContainerApi.PlaywrightBrowserType.CHROMIUM, 4444));
        }
        String string = this.chromiumWsEndpoint;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final synchronized String getFirefoxWsEndpoint$testcontainers_playwright() {
        if (this.firefoxWsEndpoint == null) {
            this.firefoxWsEndpoint = this.createBrowserAndGetWsEndpoint(new ContainerApi.LaunchRequest(ContainerApi.PlaywrightBrowserType.FIREFOX, 4445));
        }
        String string = this.firefoxWsEndpoint;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final synchronized String getWebkitWsEndpoint$testcontainers_playwright() {
        if (this.webkitWsEndpoint == null) {
            this.webkitWsEndpoint = this.createBrowserAndGetWsEndpoint(new ContainerApi.LaunchRequest(ContainerApi.PlaywrightBrowserType.WEBKIT, 4446));
        }
        String string = this.webkitWsEndpoint;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final String createBrowserAndGetWsEndpoint(ContainerApi.LaunchRequest params) {
        PlaywrightContainerKt.access$getLog$p().debug((Function0<? extends Object>)((Function0)new Function0<Object>(params){
            final /* synthetic */ ContainerApi.LaunchRequest $params;
            {
                this.$params = $params;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Launching a new browser in container: " + this.$params;
            }
        }));
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + this.getHost() + ":" + this.getMappedPort(3000) + "/launch")).POST(HttpRequest.BodyPublishers.ofString(this.json.encodeToString((SerializationStrategy)ContainerApi.LaunchRequest.Companion.serializer(), params))).build();
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IllegalStateException("Failed to launch browser in container: " + response.statusCode() + " / " + response.headers().map() + " / [" + response.body() + "]");
        }
        String responseBody = response.body();
        PlaywrightContainerKt.access$getLog$p().debug((Function0<? extends Object>)((Function0)new Function0<Object>(responseBody){
            final /* synthetic */ String $responseBody;
            {
                this.$responseBody = $responseBody;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Got response from the container: " + this.$responseBody;
            }
        }));
        DeserializationStrategy deserializationStrategy = ContainerApi.LaunchResponse.Companion.serializer();
        Intrinsics.checkNotNullExpressionValue((Object)responseBody, (String)"responseBody");
        ContainerApi.LaunchResponse jsonResponse = (ContainerApi.LaunchResponse)this.json.decodeFromString(deserializationStrategy, responseBody);
        String wsPath = jsonResponse.getWsPath();
        String wsEndpoint = "ws://" + this.getHost() + ":" + this.getMappedPort(params.getPort()) + "/" + wsPath;
        PlaywrightContainerKt.access$getLog$p().debug((Function0<? extends Object>)((Function0)new Function0<Object>(wsPath, wsEndpoint){
            final /* synthetic */ String $wsPath;
            final /* synthetic */ String $wsEndpoint;
            {
                this.$wsPath = $wsPath;
                this.$wsEndpoint = $wsEndpoint;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Will connect to " + this.$wsPath + " (" + this.$wsEndpoint + ")";
            }
        }));
        return wsEndpoint;
    }

    private static final String start$lambda$1(InputStream stream) {
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
        InputStream inputStream = stream;
        Charset charset = Charsets.UTF_8;
        return new InputStreamReader(inputStream, charset).toString();
    }

    public PlaywrightContainer() {
        this(null, 1, null);
    }

    public static final /* synthetic */ String access$getPlaywrightVersionCompatibleTag$p(PlaywrightContainer $this) {
        return $this.playwrightVersionCompatibleTag;
    }

    public static final /* synthetic */ String access$getPlaywrightVersion$p(PlaywrightContainer $this) {
        return $this.playwrightVersion;
    }
}

