/*
 * Decompiled with CFR 0.152.
 */
package io.orangebuffalo.testcontainers.playwright;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.Playwright;
import io.orangebuffalo.testcontainers.playwright.PlaywrightUtilsKt;
import io.orangebuffalo.testcontainers.playwright.shadow.mu.KLogger;
import io.orangebuffalo.testcontainers.playwright.shadow.mu.KotlinLogging;
import io.orangebuffalo.testcontainers.playwright.shadow.org.jetbrains.annotations.NotNull;
import io.orangebuffalo.testcontainers.playwright.shadow.org.jetbrains.annotations.Nullable;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"log", "Lio/orangebuffalo/testcontainers/playwright/shadow/mu/KLogger;", "getPlaywrightVersionOnClasspath", "", "safeClose", "", "Lcom/microsoft/playwright/Browser;", "Lcom/microsoft/playwright/Playwright;", "testcontainers-playwright"})
public final class PlaywrightUtilsKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0<Unit>)((Function0)log.1.INSTANCE));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String getPlaywrightVersionOnClasspath() {
        Set playwrightVersions = new LinkedHashSet();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> manifests = classLoader.getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL manifestURL = manifests.nextElement();
                Closeable closeable = manifestURL.openStream();
                Throwable throwable = null;
                try {
                    String implementationVersion;
                    InputStream inputStream = (InputStream)closeable;
                    boolean bl = false;
                    Manifest manifest = new Manifest();
                    manifest.read(inputStream);
                    String implementationTitle = manifest.getMainAttributes().getValue("Implementation-Title");
                    if (Intrinsics.areEqual((Object)implementationTitle, (Object)"Playwright - Main Library") && (implementationVersion = manifest.getMainAttributes().getValue("Implementation-Version")) != null) {
                        playwrightVersions.add(implementationVersion);
                        log.debug((Function0<? extends Object>)((Function0)new Function0<Object>(implementationVersion){
                            final /* synthetic */ String $implementationVersion;
                            {
                                this.$implementationVersion = $implementationVersion;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "Playwright version " + this.$implementationVersion + " detected on classpath";
                            }
                        }));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        catch (Exception e) {
            log.warn(e, (Function0<? extends Object>)((Function0)getPlaywrightVersionOnClasspath.2.INSTANCE));
        }
        if (playwrightVersions.isEmpty()) {
            log.warn("Failed to determine Playwright version from classpath - will use the provided one");
            return null;
        }
        if (playwrightVersions.size() > 1) {
            log.warn((Function0<? extends Object>)((Function0)new Function0<Object>((Set<String>)playwrightVersions){
                final /* synthetic */ Set<String> $playwrightVersions;
                {
                    this.$playwrightVersions = $playwrightVersions;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Multiple versions of Playwright API found on classpath (" + this.$playwrightVersions + ") - will use the provided one";
                }
            }));
            return null;
        }
        String playwrightVersion = (String)CollectionsKt.first((Iterable)playwrightVersions);
        log.debug((Function0<? extends Object>)((Function0)new Function0<Object>(playwrightVersion){
            final /* synthetic */ String $playwrightVersion;
            {
                this.$playwrightVersion = $playwrightVersion;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Found Playwright version " + this.$playwrightVersion;
            }
        }));
        return playwrightVersion;
    }

    public static final void safeClose(@NotNull Browser $this$safeClose) {
        Intrinsics.checkNotNullParameter((Object)$this$safeClose, (String)"<this>");
        try {
            $this$safeClose.close();
        }
        catch (Exception e) {
            log.warn(e, (Function0<? extends Object>)((Function0)safeClose.1.INSTANCE));
        }
    }

    public static final void safeClose(@NotNull Playwright $this$safeClose) {
        Intrinsics.checkNotNullParameter((Object)$this$safeClose, (String)"<this>");
        try {
            $this$safeClose.close();
        }
        catch (Exception e) {
            log.warn(e, (Function0<? extends Object>)((Function0)safeClose.2.INSTANCE));
        }
    }
}

