/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;

@Mojo(name="resolve-pom", defaultPhase=LifecyclePhase.INITIALIZE)
public class ResolvePomMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.artifact}", readonly=true, required=true)
    private Artifact artifact;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.file}", required=true, readonly=true)
    private File pomFile;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${project.build.directory}/resolved-pom.xml", required=true)
    private File resolvedPomFile;
    @Parameter(required=true)
    private Map<String, String> properties;
    @Parameter(property="resolve-pom.overwrite", defaultValue="true", required=false)
    private boolean overwriteExisting;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter fileFilter;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        if (this.resolvedPomFile.equals(this.pomFile)) {
            this.getLog().info((CharSequence)String.format("Input pom file %s is the same as the output pom %s, this happens for multiple runs in the same build, and is probably safe to ignore", this.pomFile, this.resolvedPomFile));
            return;
        }
        Properties additionalProperties = new Properties();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            additionalProperties.put(entry.getKey(), entry.getValue() == null ? "" : entry.getValue());
        }
        this.getLog().info((CharSequence)String.format("Filtering pom at %s to %s", this.pomFile, this.resolvedPomFile));
        File outputDirectory = this.resolvedPomFile.getParentFile();
        boolean createdOutputDirectory = outputDirectory.mkdirs();
        this.getLog().debug((CharSequence)String.format("Ensure output directory %s : %s", outputDirectory.getName(), createdOutputDirectory));
        if (!this.resolvedPomFile.exists() || this.overwriteExisting) {
            this.resolvePom(additionalProperties);
        } else {
            this.getLog().info((CharSequence)String.format("output file already exists at %s if you wanted to overwrite it set resolve-pom.overwrite=true", this.resolvedPomFile));
        }
        this.artifact.addMetadata((ArtifactMetadata)new ResolvedProjectArtifactMetadata(this.artifact, this.resolvedPomFile));
        this.project.setFile(this.resolvedPomFile);
    }

    private void resolvePom(Properties additionalProperties) throws MojoExecutionException {
        boolean enableFiltering = true;
        try {
            boolean createdResolvedPomFile = this.resolvedPomFile.createNewFile();
            this.getLog().debug((CharSequence)String.format("Ensure output file %s : %s", this.resolvedPomFile.getName(), createdResolvedPomFile));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating output file", e);
        }
        MavenFileFilterRequest mavenFileFilterRequest = new MavenFileFilterRequest(this.pomFile, this.resolvedPomFile, true, null, new ArrayList(), false, this.encoding, null, additionalProperties);
        try {
            this.fileFilter.copyFile(mavenFileFilterRequest);
        }
        catch (MavenFilteringException e) {
            this.getLog().error((CharSequence)"Failed to create filtered pom");
            throw new MojoExecutionException("Failed to create a filtered pom", (Exception)((Object)e));
        }
        this.getLog().info((CharSequence)String.format("Filtered pom to %s", this.resolvedPomFile));
    }

    private class ResolvedProjectArtifactMetadata
    extends ProjectArtifactMetadata {
        public ResolvedProjectArtifactMetadata(Artifact artifact, File file) {
            super(artifact, file);
        }

        public void merge(ArtifactMetadata metadata) {
            ResolvePomMojo.this.getLog().info((CharSequence)("Got a request to merge metadata for: " + metadata.getKey() + " " + metadata.getRemoteFilename()));
        }
    }
}

