/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.tokenParser;

import com.mitchellbosecke.pebble.error.ParserException;
import com.mitchellbosecke.pebble.lexer.Token;
import com.mitchellbosecke.pebble.lexer.TokenStream;
import com.mitchellbosecke.pebble.node.BlockNode;
import com.mitchellbosecke.pebble.node.EmbedNode;
import com.mitchellbosecke.pebble.node.RenderableNode;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.node.expression.MapExpression;
import com.mitchellbosecke.pebble.parser.Parser;
import com.mitchellbosecke.pebble.tokenParser.BlockTokenParser;
import com.mitchellbosecke.pebble.tokenParser.TokenParser;
import java.util.ArrayList;
import java.util.List;

public class EmbedTokenParser
implements TokenParser {
    private BlockTokenParser blockTokenParser = new BlockTokenParser();

    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        Expression<?> embedExpression = parser.getExpressionParser().parseExpression();
        Token current = stream.current();
        MapExpression mapExpression = null;
        if (current.getType().equals((Object)Token.Type.NAME) && current.getValue().equals("with")) {
            stream.next();
            Expression<?> parsedExpression = parser.getExpressionParser().parseExpression();
            if (parsedExpression instanceof MapExpression) {
                mapExpression = (MapExpression)parsedExpression;
            } else {
                throw new ParserException(null, String.format("Unexpected expression '%1s'.", parsedExpression.getClass().getCanonicalName()), token.getLineNumber(), stream.getFilename());
            }
        }
        stream.expect(Token.Type.EXECUTE_END);
        List<BlockNode> blocks = this.parseBlocks(token, parser, stream);
        return new EmbedNode(lineNumber, embedExpression, mapExpression, blocks);
    }

    private List<BlockNode> parseBlocks(Token token, Parser parser, TokenStream stream) {
        BlockNode node;
        ArrayList<BlockNode> blocks = new ArrayList<BlockNode>();
        while ((node = this.parseBlock(token, parser, stream)) != null) {
            blocks.add(node);
        }
        return blocks;
    }

    private BlockNode parseBlock(Token token, Parser parser, TokenStream stream) {
        Token textToken;
        if (stream.current().test(Token.Type.TEXT) && (textToken = stream.expect(Token.Type.TEXT)).getValue().trim().length() > 0) {
            throw new ParserException(null, "A template that extends another one cannot include content outside blocks. Did you forget to put the content inside a {% block %} tag?", textToken.getLineNumber(), stream.getFilename());
        }
        stream.expect(Token.Type.EXECUTE_START);
        if (stream.current().test(Token.Type.NAME, "end" + this.getTag())) {
            stream.expect(Token.Type.NAME, "end" + this.getTag());
            stream.expect(Token.Type.EXECUTE_END);
            return null;
        }
        return (BlockNode)this.blockTokenParser.parse(token, parser);
    }

    @Override
    public String getTag() {
        return "embed";
    }
}

