/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.utils;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.RenderedSizeContext;
import java.io.IOException;
import java.io.Writer;

public class LimitedSizeWriter
extends Writer {
    private final Writer internalWriter;
    private final RenderedSizeContext context;

    public static Writer from(Writer internalWriter, RenderedSizeContext context) {
        if (context.getMaxRenderedSize() < 0) {
            return internalWriter;
        }
        return new LimitedSizeWriter(internalWriter, context);
    }

    private LimitedSizeWriter(Writer internalWriter, RenderedSizeContext context) {
        if (context.getMaxRenderedSize() < 0) {
            throw new IllegalArgumentException("maxRenderedSize should not be negative");
        }
        this.internalWriter = internalWriter;
        this.context = context;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.willExceedMaxChars(len)) {
            throw new PebbleException(null, String.format("Tried to write more than %d chars.", this.context.getMaxRenderedSize()));
        }
        this.internalWriter.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.internalWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.internalWriter.close();
    }

    public String toString() {
        return this.internalWriter.toString();
    }

    private boolean willExceedMaxChars(int charsToWrite) {
        return this.context.addAndGet(charsToWrite) > this.context.getMaxRenderedSize();
    }
}

