/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.attributes;

import io.pebbletemplates.pebble.attributes.ArrayResolver;
import io.pebbletemplates.pebble.attributes.AttributeResolver;
import io.pebbletemplates.pebble.attributes.ListResolver;
import io.pebbletemplates.pebble.attributes.MacroResolver;
import io.pebbletemplates.pebble.attributes.MapResolver;
import io.pebbletemplates.pebble.attributes.MemberCacheUtils;
import io.pebbletemplates.pebble.attributes.ResolvedAttribute;
import io.pebbletemplates.pebble.node.ArgumentsNode;
import io.pebbletemplates.pebble.template.EvaluationContextImpl;
import io.pebbletemplates.pebble.template.MacroAttributeProvider;
import io.pebbletemplates.pebble.utils.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class DefaultAttributeResolver
implements AttributeResolver {
    private final MemberCacheUtils memberCacheUtils = new MemberCacheUtils();

    @Override
    public ResolvedAttribute resolve(Object instance, Object attributeNameValue, Object[] argumentValues, ArgumentsNode args, EvaluationContextImpl context, String filename, int lineNumber) {
        if (instance != null) {
            Class<?>[] argumentTypes;
            String attributeName = String.valueOf(attributeNameValue);
            Member member = this.memberCacheUtils.getMember(instance, attributeName, argumentTypes = this.getArgumentTypes(argumentValues));
            if (member == null) {
                if (argumentValues == null) {
                    ResolvedAttribute resolvedAttribute;
                    if (instance instanceof Map) {
                        return MapResolver.INSTANCE.resolve(instance, attributeNameValue, null, args, context, filename, lineNumber);
                    }
                    if (instance.getClass().isArray()) {
                        return ArrayResolver.INSTANCE.resolve(instance, attributeNameValue, null, args, context, filename, lineNumber);
                    }
                    if (instance instanceof List && (resolvedAttribute = ListResolver.INSTANCE.resolve(instance, attributeNameValue, null, args, context, filename, lineNumber)) != null) {
                        return resolvedAttribute;
                    }
                }
                if (instance instanceof MacroAttributeProvider) {
                    return MacroResolver.INSTANCE.resolve(instance, attributeNameValue, argumentValues, args, context, filename, lineNumber);
                }
                member = this.memberCacheUtils.cacheMember(instance, attributeName, argumentTypes, context, filename, lineNumber);
            }
            if (member != null) {
                return new ResolvedAttribute(this.invokeMember(instance, member, argumentValues));
            }
        }
        return null;
    }

    private Class<?>[] getArgumentTypes(Object[] argumentValues) {
        if (argumentValues != null) {
            Class[] argumentTypes = new Class[argumentValues.length];
            for (int i = 0; i < argumentValues.length; ++i) {
                Object o = argumentValues[i];
                argumentTypes[i] = o == null ? null : o.getClass();
            }
            return argumentTypes;
        }
        return new Class[0];
    }

    private Object invokeMember(Object object, Member member, Object[] argumentValues) {
        Object result = null;
        try {
            if (member instanceof Method) {
                Method method = (Method)member;
                argumentValues = TypeUtils.compatibleCast(argumentValues, method.getParameterTypes());
                result = method.invoke(object, argumentValues);
            } else if (member instanceof Field) {
                result = ((Field)member).get(object);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

