/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.node;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.NodeVisitor;
import io.pebbletemplates.pebble.node.AbstractRenderableNode;
import io.pebbletemplates.pebble.node.BodyNode;
import io.pebbletemplates.pebble.node.expression.Expression;
import io.pebbletemplates.pebble.node.fornode.LazyLength;
import io.pebbletemplates.pebble.node.fornode.LazyRevIndex;
import io.pebbletemplates.pebble.template.EvaluationContextImpl;
import io.pebbletemplates.pebble.template.PebbleTemplateImpl;
import io.pebbletemplates.pebble.template.ScopeChain;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ForNode
extends AbstractRenderableNode {
    private final String variableName;
    private final Expression<?> iterableExpression;
    private final BodyNode body;
    private final BodyNode elseBody;

    public ForNode(int lineNumber, String variableName, Expression<?> iterableExpression, BodyNode body, BodyNode elseBody) {
        super(lineNumber);
        this.variableName = variableName;
        this.iterableExpression = iterableExpression;
        this.body = body;
        this.elseBody = elseBody;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContextImpl context) throws IOException {
        Object iterableEvaluation = this.iterableExpression.evaluate(self, context);
        if (iterableEvaluation == null) {
            return;
        }
        Iterable<Object> iterable = this.toIterable(iterableEvaluation);
        if (iterable == null) {
            throw new PebbleException(null, "Not an iterable object. Value = [" + iterableEvaluation.toString() + "]", this.getLineNumber(), self.getName());
        }
        Iterator<Object> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            boolean usingExecutorService;
            ScopeChain scopeChain = context.getScopeChain();
            scopeChain.pushScope();
            LazyLength length = new LazyLength(iterableEvaluation);
            int index = 0;
            LoopVariables loop = null;
            boolean bl = usingExecutorService = context.getExecutorService() != null;
            while (iterator.hasNext()) {
                if (index == 0 || usingExecutorService) {
                    loop = new LoopVariables();
                    loop.first = index == 0;
                    loop.last = !iterator.hasNext();
                    loop.length = length;
                } else if (index == 1) {
                    loop.first = false;
                }
                loop.revindex = new LazyRevIndex(index, length);
                loop.index = index++;
                scopeChain.put("loop", loop);
                scopeChain.put(this.variableName, iterator.next());
                if (!iterator.hasNext()) {
                    loop.last = true;
                }
                this.body.render(self, writer, context);
            }
            scopeChain.popScope();
        } else if (this.elseBody != null) {
            this.elseBody.render(self, writer, context);
        }
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public String getIterationVariable() {
        return this.variableName;
    }

    public Expression<?> getIterable() {
        return this.iterableExpression;
    }

    public BodyNode getBody() {
        return this.body;
    }

    public BodyNode getElseBody() {
        return this.elseBody;
    }

    private Iterable<Object> toIterable(Object obj) {
        Iterable result = null;
        if (obj instanceof Iterable) {
            result = (Set)obj;
        } else if (obj instanceof Map) {
            result = ((Map)obj).entrySet();
        } else if (obj.getClass().isArray()) {
            result = new ArrayIterable(obj);
        } else if (obj instanceof Enumeration) {
            result = new EnumerationIterable((Enumeration)obj);
        }
        return result;
    }

    public static class LoopVariables {
        private boolean first;
        private boolean last;
        private LazyLength length;
        private int index;
        private LazyRevIndex revindex;

        public String toString() {
            return "{last=" + this.last + ", length=" + this.length + ", index=" + this.index + ", revindex=" + this.revindex + ", first=" + this.first + "}";
        }

        public boolean isFirst() {
            return this.first;
        }

        public boolean isLast() {
            return this.last;
        }

        public LazyLength getLength() {
            return this.length;
        }

        public int getIndex() {
            return this.index;
        }

        public LazyRevIndex getRevindex() {
            return this.revindex;
        }
    }

    private class ArrayIterable
    implements Iterable<Object> {
        private Object obj;

        ArrayIterable(Object array) {
            this.obj = array;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private int index = 0;
                private final int length = Array.getLength(ArrayIterable.access$500(ArrayIterable.this));

                @Override
                public boolean hasNext() {
                    return this.index < this.length;
                }

                @Override
                public Object next() {
                    return Array.get(ArrayIterable.this.obj, this.index++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class EnumerationIterable
    implements Iterable<Object> {
        private Enumeration<Object> obj;

        EnumerationIterable(Enumeration<Object> enumeration) {
            this.obj = enumeration;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return EnumerationIterable.this.obj.hasMoreElements();
                }

                @Override
                public Object next() {
                    return EnumerationIterable.this.obj.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

