/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.jdbc;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.jdbc.AbstractJdbcUrlCreator;

public class MySqlJdbcUrlCreator
extends AbstractJdbcUrlCreator {
    public static final String MYSQL_SCHEME = "mysql";
    public static final String MYSQL_TAG = "mysql";
    public static final String MYSQL_LABEL = "mysql";

    @Override
    public boolean isDatabaseService(CfService cfService) {
        return this.jdbcUrlMatchesScheme(cfService, "mysql") || cfService.existsByTagIgnoreCase(new String[]{"mysql"}) || cfService.existsByLabelStartsWith("mysql") || cfService.existsByUriSchemeStartsWith(new String[]{"mysql"}) || cfService.existsByCredentialsContainsUriField(new String[]{"mysql"});
    }

    @Override
    public String getDriverClassName() {
        String driverClassNameToUse = null;
        try {
            driverClassNameToUse = "org.mariadb.jdbc.Driver";
            Class.forName(driverClassNameToUse, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                driverClassNameToUse = "com.mysql.cj.jdbc.Driver";
                Class.forName(driverClassNameToUse, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e2) {
                return null;
            }
        }
        return driverClassNameToUse;
    }

    @Override
    public String buildJdbcUrlFromUriField(CfCredentials cfCredentials) {
        UriInfo uriInfo = cfCredentials.getUriInfo("mysql");
        return String.format("%s%s://%s%s/%s%s%s", "jdbc:", "mysql", uriInfo.getHost(), uriInfo.formatPort(), uriInfo.getPath(), uriInfo.formatUserNameAndPassword(), uriInfo.formatQuery());
    }
}

