/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.jdbc;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.jdbc.AbstractJdbcUrlCreator;

public class SqlServerJdbcUrlCreator
extends AbstractJdbcUrlCreator {
    public static final String SQLSERVER_SCHEME = "sqlserver";
    public static final String SQLSERVER_LABEL = "sqlserver";

    @Override
    public String buildJdbcUrlFromUriField(CfCredentials cfCredentials) {
        UriInfo uriInfo = cfCredentials.getUriInfo("sqlserver");
        return String.format("jdbc:%s://%s:%d;database=%s;user=%s;password=%s", "sqlserver", uriInfo.getHost(), uriInfo.getPort(), uriInfo.getPath(), UriInfo.urlEncode((String)uriInfo.getUsername()), UriInfo.urlEncode((String)uriInfo.getPassword()));
    }

    @Override
    public boolean isDatabaseService(CfService cfService) {
        return this.jdbcUrlMatchesScheme(cfService, "sqlserver") || cfService.existsByLabelStartsWith("sqlserver") || cfService.existsByUriSchemeStartsWith(new String[]{"sqlserver"}) || cfService.existsByCredentialsContainsUriField(new String[]{"sqlserver"});
    }

    @Override
    public String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }
}

