/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.byteStream.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.byteStream.ByteStreamWriter;
import io.pravega.client.segment.impl.SegmentMetadataClient;
import io.pravega.client.segment.impl.SegmentOutputStream;
import io.pravega.client.stream.impl.PendingEvent;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.ByteBuffer;
import lombok.Generated;
import lombok.NonNull;

public class ByteStreamWriterImpl
extends ByteStreamWriter {
    @NonNull
    private final SegmentOutputStream out;
    @NonNull
    private final SegmentMetadataClient meta;

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(ByteBuffer src) throws IOException {
        this.out.write(PendingEvent.withoutHeader(null, src, null));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuffer data = ByteBuffer.wrap(b, off, len);
        this.out.write(PendingEvent.withoutHeader(null, data, null));
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.meta.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void closeAndSeal() throws IOException {
        this.out.close();
        this.meta.sealSegment();
        this.meta.close();
    }

    @Override
    public long fetchTailOffset() {
        return this.meta.fetchCurrentSegmentLength();
    }

    @Override
    public void truncateDataBefore(long offset) {
        this.meta.truncateSegment(offset);
    }

    @ConstructorProperties(value={"out", "meta"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteStreamWriterImpl(@NonNull SegmentOutputStream out, @NonNull SegmentMetadataClient meta) {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        this.out = out;
        this.meta = meta;
    }
}

