/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.connection.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.ClientConfig;
import io.pravega.client.connection.impl.ClientConnection;
import io.pravega.client.connection.impl.ConnectionFactory;
import io.pravega.client.connection.impl.TcpClientConnection;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import io.pravega.shared.protocol.netty.ReplyProcessor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketConnectionFactoryImpl
implements ConnectionFactory {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SocketConnectionFactoryImpl.class);
    private static final AtomicInteger POOLCOUNT = new AtomicInteger();
    private final AtomicInteger openSocketCount = new AtomicInteger();
    private final ClientConfig clientConfig;
    private final ScheduledExecutorService internalExecutor;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public SocketConnectionFactoryImpl(ClientConfig clientConfig) {
        this(clientConfig, (Integer)null);
    }

    @VisibleForTesting
    public SocketConnectionFactoryImpl(ClientConfig clientConfig, Integer numThreadsInPool) {
        this.clientConfig = (ClientConfig)Preconditions.checkNotNull((Object)clientConfig, (Object)"clientConfig");
        this.internalExecutor = ExecutorServiceHelpers.newScheduledThreadPool((int)this.getThreadPoolSize(numThreadsInPool), (String)("clientInternal-" + POOLCOUNT.incrementAndGet()));
    }

    @VisibleForTesting
    public SocketConnectionFactoryImpl(ClientConfig clientConfig, ScheduledExecutorService executor) {
        this.clientConfig = (ClientConfig)Preconditions.checkNotNull((Object)clientConfig, (Object)"clientConfig");
        this.internalExecutor = executor;
    }

    @Override
    public CompletableFuture<ClientConnection> establishConnection(PravegaNodeUri endpoint, ReplyProcessor rp) {
        this.openSocketCount.incrementAndGet();
        return TcpClientConnection.connect(endpoint, this.clientConfig, rp, this.internalExecutor, this.openSocketCount::decrementAndGet).thenApply(c -> c);
    }

    private int getThreadPoolSize(Integer threadCount) {
        if (threadCount != null) {
            return threadCount;
        }
        String configuredThreads = System.getProperty("pravega.client.internal.threadpool.size", null);
        if (configuredThreads != null) {
            return Integer.parseInt(configuredThreads);
        }
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void close() {
        log.info("Shutting down connection factory");
        if (this.closed.compareAndSet(false, true)) {
            ExecutorServiceHelpers.shutdown((ExecutorService[])new ExecutorService[]{this.internalExecutor});
        }
    }

    @VisibleForTesting
    public int getOpenSocketCount() {
        return this.openSocketCount.get();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScheduledExecutorService getInternalExecutor() {
        return this.internalExecutor;
    }
}

