/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.impl.StreamImpl;
import io.pravega.shared.NameUtils;
import java.beans.ConstructorProperties;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public class Segment
implements Comparable<Segment>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String scope;
    @NonNull
    private final String streamName;
    private final long segmentId;
    private final transient String scopedName;

    public Segment(String scope, String streamName, long id) {
        this.scope = scope;
        this.streamName = streamName;
        this.segmentId = id;
        this.scopedName = NameUtils.getQualifiedStreamSegmentName((String)scope, (String)streamName, (long)id);
    }

    public String getScopedStreamName() {
        return NameUtils.getScopedStreamName((String)this.scope, (String)this.streamName);
    }

    public String getScopedName() {
        return NameUtils.getQualifiedStreamSegmentName((String)this.scope, (String)this.streamName, (long)this.segmentId);
    }

    public String getKVTScopedName() {
        return NameUtils.getQualifiedTableSegmentName((String)this.scope, (String)this.streamName, (long)this.segmentId);
    }

    public Stream getStream() {
        return new StreamImpl(this.scope, this.streamName);
    }

    public String toString() {
        return this.getScopedName();
    }

    public static Segment fromScopedName(String qualifiedName) {
        if (NameUtils.isTransactionSegment((String)qualifiedName)) {
            String originalSegmentName = NameUtils.getParentStreamSegmentName((String)qualifiedName);
            return Segment.fromScopedName(originalSegmentName);
        }
        List tokens = NameUtils.extractSegmentTokens((String)qualifiedName);
        if (tokens.size() == 2) {
            String scope = null;
            String streamName = (String)tokens.get(0);
            long segmentId = Long.parseLong((String)tokens.get(1));
            return new Segment(scope, streamName, segmentId);
        }
        String scope = (String)tokens.get(0);
        String streamName = (String)tokens.get(1);
        long segmentId = Long.parseLong((String)tokens.get(2));
        return new Segment(scope, streamName, segmentId);
    }

    @Override
    public int compareTo(Segment o) {
        int result = this.scope.compareTo(o.scope);
        if (result == 0) {
            result = this.streamName.compareTo(o.streamName);
        }
        if (result == 0) {
            result = Long.compare(this.segmentId, o.segmentId);
        }
        return result;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.getScopedName());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStreamName() {
        return this.streamName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getSegmentId() {
        return this.segmentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$streamName = this.getStreamName();
        String other$streamName = other.getStreamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        return this.getSegmentId() == other.getSegmentId();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Segment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $streamName = this.getStreamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        long $segmentId = this.getSegmentId();
        result = result * 59 + (int)($segmentId >>> 32 ^ $segmentId);
        return result;
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String value;

        Object readResolve() throws ObjectStreamException {
            return Segment.fromScopedName(this.value);
        }

        @ConstructorProperties(value={"value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SerializedForm(String value) {
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerializedForm)) {
                return false;
            }
            SerializedForm other = (SerializedForm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SerializedForm;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Segment.SerializedForm(value=" + this.getValue() + ")";
        }
    }
}

