/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.TableKey;
import io.pravega.client.tables.Version;
import java.beans.ConstructorProperties;
import lombok.Generated;
import lombok.NonNull;

public class TableEntry<KeyT, ValueT> {
    @NonNull
    private final TableKey<KeyT> key;
    private final ValueT value;

    public static <KeyT, ValueT> TableEntry<KeyT, ValueT> unversioned(KeyT key, ValueT value) {
        return new TableEntry<KeyT, ValueT>(TableKey.unversioned(key), value);
    }

    public static <KeyT, ValueT> TableEntry<KeyT, ValueT> notExists(KeyT key, ValueT value) {
        return new TableEntry<KeyT, ValueT>(TableKey.notExists(key), value);
    }

    public static <KeyT, ValueT> TableEntry<KeyT, ValueT> versioned(KeyT key, Version version, ValueT value) {
        return new TableEntry<KeyT, ValueT>(TableKey.versioned(key, version), value);
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TableKey<KeyT> getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ValueT getValue() {
        return this.value;
    }

    @ConstructorProperties(value={"key", "value"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private TableEntry(@NonNull TableKey<KeyT> key, ValueT value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.value = value;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "TableEntry(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }
}

