/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.CompositeBufferView;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import lombok.NonNull;

@NotThreadSafe
public class BufferViewBuilder {
    private int length;
    private final List<BufferView> components;

    BufferViewBuilder(int expectedComponentCount) {
        this.components = new ArrayList<BufferView>(expectedComponentCount);
        this.length = 0;
    }

    public BufferViewBuilder add(@NonNull BufferView bufferView) {
        if (bufferView == null) {
            throw new NullPointerException("bufferView is marked non-null but is null");
        }
        if (bufferView.getLength() == 0) {
            return this;
        }
        if (bufferView instanceof CompositeBufferView) {
            this.components.addAll(((CompositeBufferView)bufferView).getComponents());
        } else {
            this.components.add(bufferView);
        }
        this.length += bufferView.getLength();
        return this;
    }

    public BufferView build() {
        int cs = this.components.size();
        if (cs == 0) {
            return BufferView.empty();
        }
        if (cs == 1) {
            return this.components.get(0).slice();
        }
        return new CompositeBufferView(this.components.subList(0, this.components.size()), this.length);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getLength() {
        return this.length;
    }
}

