/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.math.MathSubscriber;
import reactor.math.MonoFromFluxOperator;

public class MonoAverageBigInteger<T>
extends MonoFromFluxOperator<T, BigInteger>
implements Fuseable {
    private final Function<? super T, ? extends Number> mapping;

    MonoAverageBigInteger(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        super(Flux.from(source));
        this.mapping = mapping;
    }

    public void subscribe(CoreSubscriber<? super BigInteger> actual) {
        this.source.subscribe(new AverageBigIntegerSubscriber<T>(actual, this.mapping));
    }

    private static final class AverageBigIntegerSubscriber<T>
    extends MathSubscriber<T, BigInteger> {
        private final Function<? super T, ? extends Number> mapping;
        private int count;
        private BigDecimal sum = BigDecimal.ZERO;

        AverageBigIntegerSubscriber(CoreSubscriber<? super BigInteger> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void reset() {
            this.count = 0;
            this.sum = BigDecimal.ZERO;
        }

        @Override
        protected @Nullable BigInteger result() {
            return this.count == 0 ? null : this.sum.divide(BigDecimal.valueOf(this.count), RoundingMode.FLOOR).toBigInteger();
        }

        @Override
        protected void updateResult(T newValue) {
            Number number = this.mapping.apply(newValue);
            BigDecimal bigDecimalValue = number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : new BigDecimal(number.toString()));
            this.sum = this.sum.add(bigDecimalValue);
            ++this.count;
        }
    }
}

