/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyConnector;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.http.HttpResources;
import reactor.ipc.netty.http.server.CompressionHandler;
import reactor.ipc.netty.http.server.HttpServerHandler;
import reactor.ipc.netty.http.server.HttpServerOperations;
import reactor.ipc.netty.http.server.HttpServerOptions;
import reactor.ipc.netty.http.server.HttpServerRequest;
import reactor.ipc.netty.http.server.HttpServerResponse;
import reactor.ipc.netty.http.server.HttpServerRoutes;
import reactor.ipc.netty.options.ServerOptions;
import reactor.ipc.netty.tcp.BlockingNettyContext;
import reactor.ipc.netty.tcp.TcpServer;

public final class HttpServer
implements NettyConnector<HttpServerRequest, HttpServerResponse> {
    private final TcpBridgeServer server;
    final HttpServerOptions options;
    static final LoggingHandler loggingHandler = new LoggingHandler(HttpServer.class);

    public static HttpServer create() {
        return HttpServer.builder().build();
    }

    public static HttpServer create(Consumer<? super HttpServerOptions.Builder> options) {
        return HttpServer.builder().options(options).build();
    }

    public static HttpServer create(int port) {
        return HttpServer.builder().bindAddress("0.0.0.0").port(port).build();
    }

    public static HttpServer create(String bindAddress) {
        return HttpServer.builder().bindAddress(bindAddress).build();
    }

    public static HttpServer create(String bindAddress, int port) {
        return HttpServer.builder().bindAddress(bindAddress).port(port).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private HttpServer(Builder builder) {
        HttpServerOptions.Builder serverOptionsBuilder = HttpServerOptions.builder();
        if (Objects.isNull(builder.options)) {
            ((HttpServerOptions.Builder)serverOptionsBuilder.host(builder.bindAddress)).port(builder.port);
        } else {
            builder.options.accept(serverOptionsBuilder);
        }
        if (!serverOptionsBuilder.isLoopAvailable()) {
            serverOptionsBuilder.loopResources(HttpResources.get());
        }
        this.options = serverOptionsBuilder.build();
        this.server = new TcpBridgeServer(this.options);
    }

    public final HttpServerOptions options() {
        return this.options.duplicate();
    }

    public String toString() {
        return "HttpServer: " + this.options.asSimpleString();
    }

    @Override
    public Mono<? extends NettyContext> newHandler(BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.server.newHandler((BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>>)handler);
    }

    public Mono<? extends NettyContext> newRouter(Consumer<? super HttpServerRoutes> routesBuilder) {
        Objects.requireNonNull(routesBuilder, "routeBuilder");
        HttpServerRoutes routes = HttpServerRoutes.newRoutes();
        routesBuilder.accept(routes);
        return this.newHandler(routes);
    }

    public BlockingNettyContext startRouter(Consumer<? super HttpServerRoutes> routesBuilder) {
        Objects.requireNonNull(routesBuilder, "routeBuilder");
        HttpServerRoutes routes = HttpServerRoutes.newRoutes();
        routesBuilder.accept(routes);
        return this.start(routes);
    }

    public void startRouterAndAwait(Consumer<? super HttpServerRoutes> routesBuilder) {
        this.startRouterAndAwait(routesBuilder, null);
    }

    public void startRouterAndAwait(Consumer<? super HttpServerRoutes> routesBuilder, Consumer<BlockingNettyContext> onStart) {
        Objects.requireNonNull(routesBuilder, "routeBuilder");
        HttpServerRoutes routes = HttpServerRoutes.newRoutes();
        routesBuilder.accept(routes);
        this.startAndAwait(routes, onStart);
    }

    public static final class Builder {
        private String bindAddress = NetUtil.LOCALHOST.getHostAddress();
        private int port = 8080;
        private Consumer<? super HttpServerOptions.Builder> options;

        private Builder() {
        }

        public final Builder bindAddress(String bindAddress) {
            this.bindAddress = Objects.requireNonNull(bindAddress, "bindAddress");
            return this;
        }

        public final Builder port(int port) {
            this.port = Objects.requireNonNull(Integer.valueOf(port), "port");
            return this;
        }

        public final Builder options(Consumer<? super HttpServerOptions.Builder> options) {
            this.options = Objects.requireNonNull(options, "options");
            return this;
        }

        public HttpServer build() {
            return new HttpServer(this);
        }
    }

    final class TcpBridgeServer
    extends TcpServer
    implements BiConsumer<ChannelPipeline, ContextHandler<Channel>> {
        TcpBridgeServer(ServerOptions options) {
            super(options);
        }

        @Override
        protected ContextHandler<Channel> doHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler, MonoSink<NettyContext> sink) {
            return ContextHandler.newServerContext(sink, HttpServer.this.options, loggingHandler, (ch, c, msg) -> HttpServerOperations.bindHttp(ch, handler, c, msg)).onPipeline(this).autoCreateOperations(false);
        }

        @Override
        public void accept(ChannelPipeline p, ContextHandler<Channel> c) {
            p.addLast("reactor.left.httpDecoder", (ChannelHandler)new HttpRequestDecoder()).addLast("reactor.left.httpEncoder", (ChannelHandler)new HttpResponseEncoder());
            if (HttpServer.this.options.minCompressionResponseSize() >= 0) {
                p.addLast("reactor.left.compressionHandler", (ChannelHandler)new CompressionHandler(HttpServer.this.options.minCompressionResponseSize()));
            }
            p.addLast("reactor.left.httpServerHandler", (ChannelHandler)new HttpServerHandler(c));
        }

        @Override
        protected LoggingHandler loggingHandler() {
            return loggingHandler;
        }
    }
}

