/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.resources;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import reactor.ipc.netty.resources.ColocatedEventLoopGroup;
import reactor.ipc.netty.resources.DefaultLoop;
import reactor.util.Logger;
import reactor.util.Loggers;

final class DefaultLoopEpoll
implements DefaultLoop {
    static final Logger log = Loggers.getLogger(DefaultLoopEpoll.class);
    private static final boolean epoll;

    DefaultLoopEpoll() {
    }

    public static boolean hasEpoll() {
        return epoll;
    }

    @Override
    public EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        return new EpollEventLoopGroup(threads, factory);
    }

    @Override
    public Class<? extends ServerChannel> getServerChannel(EventLoopGroup group) {
        return this.useEpoll(group) ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    @Override
    public Class<? extends Channel> getChannel(EventLoopGroup group) {
        return this.useEpoll(group) ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    @Override
    public Class<? extends DatagramChannel> getDatagramChannel(EventLoopGroup group) {
        return this.useEpoll(group) ? EpollDatagramChannel.class : NioDatagramChannel.class;
    }

    @Override
    public String getName() {
        return "epoll";
    }

    private boolean useEpoll(EventLoopGroup group) {
        if (group instanceof ColocatedEventLoopGroup) {
            group = ((ColocatedEventLoopGroup)group).get();
        }
        return group instanceof EpollEventLoopGroup;
    }

    static {
        boolean epollCheck = false;
        try {
            Class.forName("io.netty.channel.epoll.Epoll");
            epollCheck = Epoll.isAvailable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        epoll = epollCheck;
        if (log.isDebugEnabled()) {
            log.debug("Default Epoll support : " + epoll);
        }
    }
}

