/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.client;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.channel.AbortedException;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.http.client.HttpClientOperations;
import reactor.ipc.netty.http.client.HttpClientOptions;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;
import reactor.ipc.netty.http.client.RedirectClientException;

final class MonoHttpClientResponse
extends Mono<HttpClientResponse> {
    final HttpClient parent;
    final URI startURI;
    final HttpMethod method;
    final Function<? super HttpClientRequest, ? extends Publisher<Void>> handler;
    static final AsciiString ALL = new AsciiString((CharSequence)"*/*");

    MonoHttpClientResponse(HttpClient parent, String url, HttpMethod method, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        this.parent = parent;
        try {
            this.startURI = new URI(parent.options.formatSchemeAndHost(url, method == HttpClient.WS));
        }
        catch (URISyntaxException e) {
            throw Exceptions.bubble((Throwable)e);
        }
        this.method = method == HttpClient.WS ? HttpMethod.GET : method;
        this.handler = handler;
    }

    public void subscribe(CoreSubscriber<? super HttpClientResponse> subscriber) {
        ReconnectableBridge bridge = new ReconnectableBridge();
        bridge.activeURI = this.startURI;
        Mono.defer(() -> this.parent.client.newHandler(new HttpClientHandler(this, bridge), this.parent.options.getRemoteAddress(bridge.activeURI), HttpClientOptions.isSecure(bridge.activeURI), bridge)).retry((Predicate)bridge).cast(HttpClientResponse.class).subscribe(subscriber);
    }

    static final class ReconnectableBridge
    implements Predicate<Throwable>,
    Consumer<Channel> {
        volatile URI activeURI;
        volatile String[] redirectedFrom;
        volatile boolean retried;

        ReconnectableBridge() {
        }

        void redirect(String to) {
            String[] redirectedFrom = this.redirectedFrom;
            URI from = this.activeURI;
            try {
                this.activeURI = from.resolve(new URI(to));
            }
            catch (URISyntaxException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            if (redirectedFrom == null) {
                this.redirectedFrom = new String[]{from.toString()};
            } else {
                String[] newRedirectedFrom = new String[redirectedFrom.length + 1];
                System.arraycopy(redirectedFrom, 0, newRedirectedFrom, 0, redirectedFrom.length);
                newRedirectedFrom[redirectedFrom.length] = from.toString();
                this.redirectedFrom = newRedirectedFrom;
            }
        }

        @Override
        public void accept(Channel channel) {
            String[] redirectedFrom = this.redirectedFrom;
            if (redirectedFrom != null) {
                channel.attr(HttpClientOperations.REDIRECT_ATTR_KEY).set((Object)redirectedFrom);
            }
        }

        @Override
        public boolean test(Throwable throwable) {
            if (throwable instanceof RedirectClientException) {
                RedirectClientException re = (RedirectClientException)throwable;
                this.redirect(re.location);
                return true;
            }
            if (AbortedException.isConnectionReset(throwable) && !this.retried) {
                this.retried = true;
                this.redirect(this.activeURI.toString());
                return true;
            }
            return false;
        }
    }

    static final class HttpClientHandler
    implements BiFunction<NettyInbound, NettyOutbound, Publisher<Void>> {
        final MonoHttpClientResponse parent;
        final ReconnectableBridge bridge;

        HttpClientHandler(MonoHttpClientResponse parent, ReconnectableBridge bridge) {
            this.bridge = bridge;
            this.parent = parent;
        }

        @Override
        public Publisher<Void> apply(NettyInbound in, NettyOutbound out) {
            try {
                URI uri = this.bridge.activeURI;
                HttpClientOperations ch = (HttpClientOperations)in;
                String host = uri.getHost();
                int port = uri.getPort();
                if (port != -1 && port != 80 && port != 443) {
                    host = host + ':' + port;
                }
                ch.getNettyRequest().setUri(uri.getRawPath() + (uri.getQuery() == null ? "" : "?" + uri.getRawQuery())).setMethod(this.parent.method).setProtocolVersion(HttpVersion.HTTP_1_1).headers().add((CharSequence)HttpHeaderNames.HOST, (Object)host).add((CharSequence)HttpHeaderNames.ACCEPT, (Object)ALL);
                if (this.parent.method == HttpMethod.GET || this.parent.method == HttpMethod.HEAD || this.parent.method == HttpMethod.DELETE) {
                    ch.chunkedTransfer(false);
                }
                if (this.parent.handler != null) {
                    return this.parent.handler.apply(ch);
                }
                return ch.send();
            }
            catch (Throwable t) {
                return Mono.error((Throwable)t);
            }
        }

        public String toString() {
            return "HttpClientHandler{startURI=" + this.bridge.activeURI + ", method=" + this.parent.method + ", handler=" + this.parent.handler + '}';
        }
    }
}

