/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.kafka.receiver.ReceiverOptions;
import reactor.kafka.receiver.ReceiverPartition;

class ImmutableReceiverOptions<K, V>
implements ReceiverOptions<K, V> {
    private static final Duration DEFAULT_POLL_TIMEOUT = Duration.ofMillis(100L);
    private static final int DEFAULT_MAX_COMMIT_ATTEMPTS = 100;
    private static final Duration DEFAULT_COMMIT_RETRY_INTERVAL = Duration.ofMillis(500L);
    private final Map<String, Object> properties;
    private final List<Consumer<Collection<ReceiverPartition>>> assignListeners;
    private final List<Consumer<Collection<ReceiverPartition>>> revokeListeners;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valueDeserializer;
    private final Duration pollTimeout;
    private final Duration closeTimeout;
    private final Duration commitInterval;
    private final int commitBatchSize;
    private final int atmostOnceCommitAheadSize;
    private final int maxCommitAttempts;
    private final Duration commitRetryInterval;
    private final int maxDeferredCommits;
    private final Duration maxDelayRebalance;
    private final long commitIntervalDuringDelay;
    private final Collection<String> subscribeTopics;
    private final Collection<TopicPartition> assignTopicPartitions;
    private final Pattern subscribePattern;
    private final Supplier<Scheduler> schedulerSupplier;

    ImmutableReceiverOptions() {
        this(new HashMap<String, Object>());
    }

    ImmutableReceiverOptions(Properties properties) {
        this(properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue)));
    }

    ImmutableReceiverOptions(Map<String, Object> properties) {
        this.properties = new HashMap<String, Object>(properties);
        this.assignListeners = new ArrayList<Consumer<Collection<ReceiverPartition>>>();
        this.revokeListeners = new ArrayList<Consumer<Collection<ReceiverPartition>>>();
        this.keyDeserializer = null;
        this.valueDeserializer = null;
        this.pollTimeout = DEFAULT_POLL_TIMEOUT;
        this.closeTimeout = Duration.ofNanos(Long.MAX_VALUE);
        this.commitInterval = Duration.ofMillis(5000L);
        this.commitBatchSize = 0;
        this.atmostOnceCommitAheadSize = 0;
        this.maxCommitAttempts = 100;
        this.commitRetryInterval = DEFAULT_COMMIT_RETRY_INTERVAL;
        this.maxDeferredCommits = 0;
        this.maxDelayRebalance = Duration.ofSeconds(60L);
        this.commitIntervalDuringDelay = 100L;
        this.subscribeTopics = null;
        this.assignTopicPartitions = null;
        this.subscribePattern = null;
        this.properties.put("enable.auto.commit", "false");
        this.schedulerSupplier = Schedulers::immediate;
    }

    ImmutableReceiverOptions(Map<String, Object> properties, List<Consumer<Collection<ReceiverPartition>>> assignListeners, List<Consumer<Collection<ReceiverPartition>>> revokeListeners, Deserializer<K> deserializer, Deserializer<V> valueDeserializer, Duration pollTimeout, Duration closeTimeout, Duration commitInterval, int commitBatchSize, int atmostOnceCommitAheadSize, int maxCommitAttempts, Duration commitRetryInterval, int maxDeferredCommits, Duration maxDelayRebalance, long commitIntervalDuringDelay, Collection<String> topics, Collection<TopicPartition> partitions, Pattern pattern, Supplier<Scheduler> supplier) {
        this.properties = new HashMap<String, Object>(properties);
        this.assignListeners = new ArrayList<Consumer<Collection<ReceiverPartition>>>(assignListeners);
        this.revokeListeners = new ArrayList<Consumer<Collection<ReceiverPartition>>>(revokeListeners);
        this.keyDeserializer = deserializer;
        this.valueDeserializer = valueDeserializer;
        this.pollTimeout = pollTimeout;
        this.closeTimeout = closeTimeout;
        this.commitInterval = commitInterval;
        this.commitBatchSize = commitBatchSize;
        this.atmostOnceCommitAheadSize = atmostOnceCommitAheadSize;
        this.maxCommitAttempts = maxCommitAttempts;
        this.commitRetryInterval = commitRetryInterval;
        this.maxDeferredCommits = maxDeferredCommits;
        this.maxDelayRebalance = maxDelayRebalance;
        this.commitIntervalDuringDelay = commitIntervalDuringDelay;
        this.subscribeTopics = topics == null ? null : new HashSet<String>(topics);
        this.assignTopicPartitions = partitions == null ? null : new HashSet<TopicPartition>(partitions);
        this.subscribePattern = pattern;
        this.schedulerSupplier = supplier;
    }

    @Override
    public Map<String, Object> consumerProperties() {
        return new HashMap<String, Object>(this.properties);
    }

    @Override
    public Object consumerProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public ReceiverOptions<K, V> consumerProperty(String name, Object newValue) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(newValue);
        HashMap<String, Object> properties = new HashMap<String, Object>(this.properties);
        properties.put(name, newValue);
        return new ImmutableReceiverOptions<K, V>(properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public ReceiverOptions<K, V> withKeyDeserializer(Deserializer<K> keyDeserializer) {
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, Objects.requireNonNull(keyDeserializer), this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public Deserializer<K> keyDeserializer() {
        return this.keyDeserializer;
    }

    @Override
    public ReceiverOptions<K, V> withValueDeserializer(Deserializer<V> valueDeserializer) {
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, Objects.requireNonNull(valueDeserializer), this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public Deserializer<V> valueDeserializer() {
        return this.valueDeserializer;
    }

    @Override
    public Duration pollTimeout() {
        return this.pollTimeout;
    }

    @Override
    public ReceiverOptions<K, V> pollTimeout(Duration timeout) {
        if (timeout == null || timeout.isNegative()) {
            throw new IllegalArgumentException("Close timeout must be >= 0");
        }
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, Objects.requireNonNull(timeout), this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public Duration closeTimeout() {
        return this.closeTimeout;
    }

    @Override
    public ReceiverOptions<K, V> closeTimeout(Duration timeout) {
        if (timeout == null || timeout.isNegative()) {
            throw new IllegalArgumentException("Close timeout must be >= 0");
        }
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, Objects.requireNonNull(timeout), this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public ReceiverOptions<K, V> addAssignListener(Consumer<Collection<ReceiverPartition>> onAssign) {
        Objects.requireNonNull(onAssign);
        ArrayList<Consumer<Collection<ReceiverPartition>>> assignListeners = new ArrayList<Consumer<Collection<ReceiverPartition>>>(this.assignListeners);
        assignListeners.add(onAssign);
        return new ImmutableReceiverOptions<K, V>(this.properties, assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public ReceiverOptions<K, V> addRevokeListener(Consumer<Collection<ReceiverPartition>> onRevoke) {
        Objects.requireNonNull(onRevoke);
        ArrayList<Consumer<Collection<ReceiverPartition>>> revokeListeners = new ArrayList<Consumer<Collection<ReceiverPartition>>>(this.revokeListeners);
        revokeListeners.add(onRevoke);
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public ReceiverOptions<K, V> clearAssignListeners() {
        return new ImmutableReceiverOptions<K, V>(this.properties, new ArrayList<Consumer<Collection<ReceiverPartition>>>(), this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public ReceiverOptions<K, V> clearRevokeListeners() {
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, new ArrayList<Consumer<Collection<ReceiverPartition>>>(), this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public List<Consumer<Collection<ReceiverPartition>>> assignListeners() {
        return new ArrayList<Consumer<Collection<ReceiverPartition>>>(this.assignListeners);
    }

    @Override
    public List<Consumer<Collection<ReceiverPartition>>> revokeListeners() {
        return new ArrayList<Consumer<Collection<ReceiverPartition>>>(this.revokeListeners);
    }

    @Override
    public ReceiverOptions<K, V> subscription(Collection<String> topics) {
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, Objects.requireNonNull(topics), null, null, this.schedulerSupplier);
    }

    @Override
    public ReceiverOptions<K, V> subscription(Pattern pattern) {
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, null, null, Objects.requireNonNull(pattern), this.schedulerSupplier);
    }

    @Override
    public ReceiverOptions<K, V> assignment(Collection<TopicPartition> partitions) {
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, null, Objects.requireNonNull(partitions), null, this.schedulerSupplier);
    }

    @Override
    public Collection<TopicPartition> assignment() {
        return this.assignTopicPartitions == null ? null : new HashSet<TopicPartition>(this.assignTopicPartitions);
    }

    @Override
    public Collection<String> subscriptionTopics() {
        return this.subscribeTopics == null ? null : new HashSet<String>(this.subscribeTopics);
    }

    @Override
    public Pattern subscriptionPattern() {
        return this.subscribePattern;
    }

    @Override
    public String groupId() {
        return (String)this.consumerProperty("group.id");
    }

    @Override
    public Duration heartbeatInterval() {
        long defaultValue = 3000L;
        long heartbeatIntervalMs = this.getLongOption("heartbeat.interval.ms", defaultValue);
        return Duration.ofMillis(heartbeatIntervalMs);
    }

    @Override
    public Duration commitInterval() {
        return this.commitInterval;
    }

    @Override
    public ReceiverOptions<K, V> commitInterval(Duration commitInterval) {
        if (commitInterval == null || commitInterval.isNegative()) {
            throw new IllegalArgumentException("Commit interval must be >= 0");
        }
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public int commitBatchSize() {
        return this.commitBatchSize;
    }

    @Override
    public ReceiverOptions<K, V> commitBatchSize(int commitBatchSize) {
        if (commitBatchSize < 0) {
            throw new IllegalArgumentException("Commit batch size must be >= 0");
        }
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public int atmostOnceCommitAheadSize() {
        return this.atmostOnceCommitAheadSize;
    }

    @Override
    public ReceiverOptions<K, V> atmostOnceCommitAheadSize(int commitAheadSize) {
        if (commitAheadSize < 0) {
            throw new IllegalArgumentException("Commit ahead size must be >= 0");
        }
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, commitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public int maxCommitAttempts() {
        return this.maxCommitAttempts;
    }

    @Override
    public ReceiverOptions<K, V> maxCommitAttempts(int maxAttempts) {
        if (maxAttempts < 0) {
            throw new IllegalArgumentException("the number of attempts must be >= 0");
        }
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, maxAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public int maxDeferredCommits() {
        return this.maxDeferredCommits;
    }

    @Override
    public ReceiverOptions<K, V> maxDeferredCommits(int maxDeferred) {
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, maxDeferred, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public Duration maxDelayRebalance() {
        return this.maxDelayRebalance;
    }

    @Override
    public ReceiverOptions<K, V> maxDelayRebalance(Duration maxDelay) {
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, maxDelay, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public long commitIntervalDuringDelay() {
        return this.commitIntervalDuringDelay;
    }

    @Override
    public ReceiverOptions<K, V> commitIntervalDuringDelay(long interval) {
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, interval, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public Supplier<Scheduler> schedulerSupplier() {
        return this.schedulerSupplier;
    }

    @Override
    public ReceiverOptions<K, V> schedulerSupplier(Supplier<Scheduler> schedulerSupplier) {
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, Objects.requireNonNull(schedulerSupplier));
    }

    @Override
    public ReceiverOptions<K, V> commitRetryInterval(Duration commitRetryInterval) {
        return new ImmutableReceiverOptions<K, V>(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern, this.schedulerSupplier);
    }

    @Override
    public Duration commitRetryInterval() {
        return this.commitRetryInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getLongOption(String optionName, long defaultValue) {
        Objects.requireNonNull(optionName);
        Object value = this.consumerProperty(optionName);
        long optionValue = 0L;
        if (value == null) return defaultValue;
        if (value instanceof Long) {
            return (Long)value;
        }
        if (!(value instanceof String)) throw new ConfigException("Invalid value " + value);
        return Long.parseLong((String)value);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.assignListeners, this.revokeListeners, this.keyDeserializer, this.valueDeserializer, this.pollTimeout, this.closeTimeout, this.commitInterval, this.commitBatchSize, this.atmostOnceCommitAheadSize, this.maxCommitAttempts, this.commitRetryInterval, this.maxDeferredCommits, this.maxDelayRebalance, this.commitIntervalDuringDelay, this.subscribeTopics, this.assignTopicPartitions, this.subscribePattern);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            ImmutableReceiverOptions that = (ImmutableReceiverOptions)object;
            return Objects.equals(this.properties, that.properties) && Objects.equals(this.assignListeners, that.assignListeners) && Objects.equals(this.revokeListeners, that.revokeListeners) && Objects.equals(this.keyDeserializer, that.keyDeserializer) && Objects.equals(this.valueDeserializer, that.valueDeserializer) && Objects.equals(this.pollTimeout, that.pollTimeout) && Objects.equals(this.closeTimeout, that.closeTimeout) && Objects.equals(this.commitInterval, that.commitInterval) && Objects.equals(this.commitBatchSize, that.commitBatchSize) && Objects.equals(this.atmostOnceCommitAheadSize, that.atmostOnceCommitAheadSize) && Objects.equals(this.maxCommitAttempts, that.maxCommitAttempts) && Objects.equals(this.commitRetryInterval, that.commitRetryInterval) && Objects.equals(this.maxDeferredCommits, that.maxDeferredCommits) && Objects.equals(this.maxDelayRebalance, that.maxDelayRebalance) && Objects.equals(this.commitIntervalDuringDelay, that.commitIntervalDuringDelay) && Objects.equals(this.subscribeTopics, that.subscribeTopics) && Objects.equals(this.assignTopicPartitions, that.assignTopicPartitions) && Objects.equals(this.subscribePattern, that.subscribePattern);
        }
        return false;
    }
}

