/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.sender;

import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.naming.AuthenticationException;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.serialization.Serializer;
import reactor.core.scheduler.Scheduler;
import reactor.kafka.sender.ImmutableSenderOptions;
import reactor.kafka.sender.observation.KafkaSenderObservationConvention;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;

public interface SenderOptions<K, V> {
    @NonNull
    public static <K, V> SenderOptions<K, V> create() {
        return new ImmutableSenderOptions();
    }

    @NonNull
    public static <K, V> SenderOptions<K, V> create(@NonNull Map<String, Object> configProperties) {
        return new ImmutableSenderOptions(configProperties);
    }

    @NonNull
    public static <K, V> SenderOptions<K, V> create(@NonNull Properties configProperties) {
        return new ImmutableSenderOptions(configProperties);
    }

    @NonNull
    public Map<String, Object> producerProperties();

    @Nullable
    public Object producerProperty(@NonNull String var1);

    @NonNull
    public SenderOptions<K, V> producerProperty(@NonNull String var1, @NonNull Object var2);

    @Nullable
    public Serializer<K> keySerializer();

    @NonNull
    public SenderOptions<K, V> withKeySerializer(@NonNull Serializer<K> var1);

    @Nullable
    public Serializer<V> valueSerializer();

    @NonNull
    public SenderOptions<K, V> withValueSerializer(@NonNull Serializer<V> var1);

    @NonNull
    public Scheduler scheduler();

    @NonNull
    public SenderOptions<K, V> scheduler(@NonNull Scheduler var1);

    @NonNull
    public int maxInFlight();

    @NonNull
    public SenderOptions<K, V> maxInFlight(@NonNull int var1);

    @NonNull
    public boolean stopOnError();

    @NonNull
    public SenderOptions<K, V> stopOnError(@NonNull boolean var1);

    @NonNull
    public Duration closeTimeout();

    @NonNull
    public SenderOptions<K, V> closeTimeout(@NonNull Duration var1);

    @Nullable
    default public ProducerListener producerListener() {
        return null;
    }

    default public SenderOptions<K, V> producerListener(@Nullable ProducerListener listener) {
        return this;
    }

    @NonNull
    default public SenderOptions<K, V> withObservation(@NonNull ObservationRegistry observationRegistry) {
        return this.withObservation(observationRegistry, null);
    }

    @NonNull
    public SenderOptions<K, V> withObservation(@NonNull ObservationRegistry var1, @Nullable KafkaSenderObservationConvention var2);

    @NonNull
    public ObservationRegistry observationRegistry();

    @Nullable
    public KafkaSenderObservationConvention observationConvention();

    @NonNull
    default public boolean isTransactional() {
        String transactionalId = this.transactionalId();
        return transactionalId != null && !transactionalId.isEmpty();
    }

    @Nullable
    default public String clientId() {
        return (String)this.producerProperty("client.id");
    }

    @Nullable
    default public String transactionalId() {
        return (String)this.producerProperty("transactional.id");
    }

    @NonNull
    default public String bootstrapServers() {
        return (String)Objects.requireNonNull(this.producerProperty("bootstrap.servers"));
    }

    @NonNull
    default public boolean fatalException(@NonNull Throwable t) {
        return t instanceof AuthenticationException || t instanceof ProducerFencedException;
    }

    public static interface ProducerListener {
        default public void producerAdded(String id, Producer<?, ?> producer) {
        }

        default public void producerRemoved(String id, Producer<?, ?> producer) {
        }
    }
}

