/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.sender.observation;

import io.micrometer.observation.transport.SenderContext;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaRecordSenderContext
extends SenderContext<ProducerRecord<?, ?>> {
    private final String producerId;
    private final String destination;

    public KafkaRecordSenderContext(ProducerRecord<?, ?> record, String producerId, String kafkaServers) {
        super((carrier, key, value) -> record.headers().add(key, value.getBytes(StandardCharsets.UTF_8)));
        this.setCarrier(record);
        this.producerId = producerId;
        this.destination = record.topic();
        this.setRemoteServiceName("Apache Kafka: " + kafkaServers);
    }

    public String getProducerId() {
        return this.producerId;
    }

    public String getDestination() {
        return this.destination;
    }
}

