/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.micrometer.core.instrument.Gauge;
import java.net.SocketAddress;
import reactor.netty.Metrics;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;

final class MicrometerHttp2ConnectionProviderMeterRegistrar {
    static final String ACTIVE_STREAMS_DESCRIPTION = "The number of the active HTTP/2 streams";
    static final String PENDING_STREAMS_DESCRIPTION = "The number of requests that are waiting for opening HTTP/2 stream";
    static final MicrometerHttp2ConnectionProviderMeterRegistrar INSTANCE = new MicrometerHttp2ConnectionProviderMeterRegistrar();

    private MicrometerHttp2ConnectionProviderMeterRegistrar() {
    }

    void registerMetrics(String poolName, String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        String addressAsString = Metrics.formatSocketAddress((SocketAddress)remoteAddress);
        String[] tags = new String[]{"id", id, "remote.address", addressAsString, "name", poolName};
        Gauge.builder((String)"reactor.netty.connection.provider.active.streams", (Object)metrics, InstrumentedPool.PoolMetrics::acquiredSize).description(ACTIVE_STREAMS_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.pending.streams", (Object)metrics, InstrumentedPool.PoolMetrics::pendingAcquireSize).description(PENDING_STREAMS_DESCRIPTION).tags(tags).register(Metrics.REGISTRY);
    }
}

