/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2StreamChannel;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

abstract class AbstractHttpServerMetricsHandler
extends ChannelDuplexHandler {
    private static final Logger log = Loggers.getLogger(AbstractHttpServerMetricsHandler.class);
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final Function<String, String> uriTagValue;

    protected AbstractHttpServerMetricsHandler(@Nullable Function<String, String> uriTagValue) {
        this.uriTagValue = uriTagValue;
    }

    protected AbstractHttpServerMetricsHandler(AbstractHttpServerMetricsHandler copy) {
        this.dataReceived = copy.dataReceived;
        this.dataReceivedTime = copy.dataReceivedTime;
        this.dataSent = copy.dataSent;
        this.dataSentTime = copy.dataSentTime;
        this.uriTagValue = copy.uriTagValue;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        block3: {
            if (!(ctx.channel() instanceof Http2StreamChannel) && this.recorder() instanceof MicrometerHttpServerMetricsRecorder) {
                try {
                    this.recorder().recordServerConnectionOpened(ctx.channel().localAddress());
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
                }
            }
        }
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        block3: {
            if (!(ctx.channel() instanceof Http2StreamChannel) && this.recorder() instanceof MicrometerHttpServerMetricsRecorder) {
                try {
                    this.recorder().recordServerConnectionClosed(ctx.channel().localAddress());
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
                }
            }
        }
        ctx.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        try {
            if (msg instanceof HttpResponse) {
                if (((HttpResponse)msg).status().equals((Object)HttpResponseStatus.CONTINUE)) {
                    return;
                }
                this.dataSentTime = System.nanoTime();
            }
            this.dataSent += this.extractProcessedDataFromBuffer(msg);
            if (msg instanceof LastHttpContent) {
                promise.addListener(future -> {
                    block9: {
                        ChannelOperations channelOps = ChannelOperations.get((Channel)ctx.channel());
                        if (channelOps instanceof HttpServerOperations) {
                            HttpServerOperations ops;
                            block8: {
                                ops = (HttpServerOperations)channelOps;
                                try {
                                    this.recordWrite(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path), ops.method().name(), ops.status().codeAsText().toString());
                                }
                                catch (RuntimeException e) {
                                    if (!log.isWarnEnabled()) break block8;
                                    log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
                                }
                            }
                            if (ops.hostAddress() != null) {
                                try {
                                    if (ops.isHttp2()) {
                                        this.recordClosedStream(ops);
                                    } else {
                                        this.recordInactiveConnection(ops);
                                    }
                                }
                                catch (RuntimeException e) {
                                    if (!log.isWarnEnabled()) break block9;
                                    log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
                                }
                            }
                        }
                    }
                    this.dataSent = 0L;
                });
            }
        }
        catch (RuntimeException e) {
            if (log.isWarnEnabled()) {
                log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
            }
        }
        finally {
            ctx.write(msg, promise);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block8: {
            try {
                HttpServerOperations ops;
                ChannelOperations channelOps;
                if (msg instanceof HttpRequest) {
                    this.dataReceivedTime = System.nanoTime();
                    channelOps = ChannelOperations.get((Channel)ctx.channel());
                    if (channelOps instanceof HttpServerOperations) {
                        ops = (HttpServerOperations)channelOps;
                        if (ops.isHttp2()) {
                            this.recordOpenStream(ops);
                        } else {
                            this.recordActiveConnection(ops);
                        }
                    }
                }
                this.dataReceived += this.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    channelOps = ChannelOperations.get((Channel)ctx.channel());
                    if (channelOps instanceof HttpServerOperations) {
                        ops = (HttpServerOperations)channelOps;
                        this.recordRead(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path), ops.method().name());
                    }
                    this.dataReceived = 0L;
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block8;
                log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
            }
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        block3: {
            try {
                ChannelOperations channelOps = ChannelOperations.get((Channel)ctx.channel());
                if (channelOps instanceof HttpServerOperations) {
                    HttpServerOperations ops = (HttpServerOperations)channelOps;
                    this.recordException(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path));
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
            }
        }
        ctx.fireExceptionCaught(cause);
    }

    protected abstract HttpServerMetricsRecorder recorder();

    private long extractProcessedDataFromBuffer(Object msg) {
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        return 0L;
    }

    protected void recordException(HttpServerOperations ops, String path) {
        this.recorder().incrementErrorsCount(ops.remoteAddress(), path);
    }

    protected void recordRead(HttpServerOperations ops, String path, String method) {
        this.recorder().recordDataReceivedTime(path, method, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived(ops.remoteAddress(), path, this.dataReceived);
    }

    protected void recordWrite(HttpServerOperations ops, String path, String method, String status) {
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - this.dataSentTime);
        this.recorder().recordDataSentTime(path, method, status, dataSentTimeDuration);
        if (this.dataReceivedTime != 0L) {
            this.recorder().recordResponseTime(path, method, status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        } else {
            this.recorder().recordResponseTime(path, method, status, dataSentTimeDuration);
        }
        this.recorder().recordDataSent(ops.remoteAddress(), path, this.dataSent);
    }

    protected void recordActiveConnection(HttpServerOperations ops) {
        this.recorder().recordServerConnectionActive(ops.hostAddress());
    }

    protected void recordInactiveConnection(HttpServerOperations ops) {
        this.recorder().recordServerConnectionInactive(ops.hostAddress());
    }

    protected void recordOpenStream(HttpServerOperations ops) {
        this.recorder().recordStreamOpened(ops.hostAddress());
    }

    protected void recordClosedStream(HttpServerOperations ops) {
        this.recorder().recordStreamClosed(ops.hostAddress());
    }
}

