/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.Timer;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.transport.RequestReplySenderContext;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.netty.Metrics;
import reactor.netty.http.client.AbstractHttpClientMetricsHandler;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.http.client.HttpClientObservations;
import reactor.netty.http.client.MicrometerHttpClientMetricsRecorder;
import reactor.netty.observability.ReactorNettyHandlerContext;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

final class MicrometerHttpClientMetricsHandler
extends AbstractHttpClientMetricsHandler {
    final MicrometerHttpClientMetricsRecorder recorder;
    ResponseTimeHandlerContext responseTimeHandlerContext;
    Observation responseTimeObservation;

    MicrometerHttpClientMetricsHandler(MicrometerHttpClientMetricsRecorder recorder, @Nullable Function<String, String> uriTagValue) {
        super(uriTagValue);
        this.recorder = recorder;
    }

    MicrometerHttpClientMetricsHandler(MicrometerHttpClientMetricsHandler copy) {
        super(copy);
        this.recorder = copy.recorder;
        this.responseTimeHandlerContext = copy.responseTimeHandlerContext;
        this.responseTimeObservation = copy.responseTimeObservation;
    }

    @Override
    protected HttpClientMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void recordRead(SocketAddress address) {
        this.recorder().recordDataReceivedTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived(address, this.path, this.dataReceived);
        this.responseTimeObservation.stop();
    }

    @Override
    protected void reset() {
        super.reset();
        this.responseTimeHandlerContext = null;
        this.responseTimeObservation = null;
    }

    @Override
    protected void startRead(HttpResponse msg) {
        super.startRead(msg);
        this.responseTimeHandlerContext.setResponse(msg);
        this.responseTimeHandlerContext.status = this.status;
    }

    @Override
    protected void startWrite(HttpRequest msg, Channel channel, @Nullable ContextView contextView) {
        super.startWrite(msg, channel, contextView);
        this.responseTimeHandlerContext = new ResponseTimeHandlerContext(this.recorder, msg, this.path, channel.remoteAddress());
        this.responseTimeObservation = Observation.createNotStarted((String)(this.recorder.name() + ".response.time"), (Supplier)this.responseTimeHandlerContext, (ObservationRegistry)Metrics.OBSERVATION_REGISTRY);
        if (contextView != null && contextView.hasKey((Object)"micrometer.observation")) {
            this.responseTimeObservation.parentObservation((Observation)contextView.get((Object)"micrometer.observation"));
        }
        this.responseTimeObservation.start();
    }

    static final class ResponseTimeHandlerContext
    extends RequestReplySenderContext<HttpRequest, HttpResponse>
    implements ReactorNettyHandlerContext,
    Supplier<Observation.Context> {
        static final String HTTP_PREFIX = "http ";
        static final String TYPE = "client";
        final String method;
        final String netPeerName;
        final String netPeerPort;
        final String path;
        final MicrometerHttpClientMetricsRecorder recorder;
        String status;

        ResponseTimeHandlerContext(MicrometerHttpClientMetricsRecorder recorder, HttpRequest request, String path, SocketAddress remoteAddress) {
            super((carrier, key, value) -> Objects.requireNonNull(carrier).headers().set(key, (Object)value));
            this.recorder = recorder;
            this.method = request.method().name();
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)remoteAddress;
                this.netPeerName = address.getHostString();
                this.netPeerPort = address.getPort() + "";
            } else {
                this.netPeerName = remoteAddress.toString();
                this.netPeerPort = "";
            }
            this.path = path;
            this.setCarrier(request);
            this.setContextualName(HTTP_PREFIX + this.method);
        }

        @Override
        public Observation.Context get() {
            return this;
        }

        public Timer getTimer() {
            return this.recorder.getResponseTimeTimer(this.getName(), this.netPeerName + ":" + this.netPeerPort, this.path, this.method, this.status);
        }

        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of((String[])new String[]{HttpClientObservations.ResponseTimeHighCardinalityTags.REACTOR_NETTY_TYPE.asString(), TYPE, HttpClientObservations.ResponseTimeHighCardinalityTags.HTTP_URL.asString(), this.path, HttpClientObservations.ResponseTimeHighCardinalityTags.HTTP_STATUS_CODE.asString(), this.status, HttpClientObservations.ResponseTimeHighCardinalityTags.NET_PEER_NAME.asString(), this.netPeerName, HttpClientObservations.ResponseTimeHighCardinalityTags.NET_PEER_PORT.asString(), this.netPeerPort});
        }

        public KeyValues getLowCardinalityKeyValues() {
            return KeyValues.of((String[])new String[]{HttpClientObservations.ResponseTimeLowCardinalityTags.METHOD.asString(), this.method, HttpClientObservations.ResponseTimeLowCardinalityTags.REMOTE_ADDRESS.asString(), this.netPeerName + ":" + this.netPeerPort, HttpClientObservations.ResponseTimeLowCardinalityTags.STATUS.asString(), this.status, HttpClientObservations.ResponseTimeLowCardinalityTags.URI.asString(), this.path});
        }
    }
}

