/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.logging.LoggingHandler;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.ByteBufMono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.NettyOutbound;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.HttpResources;
import reactor.netty.http.client.HttpClientConfiguration;
import reactor.netty.http.client.HttpClientConnect;
import reactor.netty.http.client.HttpClientCookie;
import reactor.netty.http.client.HttpClientCookieWhen;
import reactor.netty.http.client.HttpClientDoOn;
import reactor.netty.http.client.HttpClientFinalizer;
import reactor.netty.http.client.HttpClientForm;
import reactor.netty.http.client.HttpClientHeaders;
import reactor.netty.http.client.HttpClientHeadersWhen;
import reactor.netty.http.client.HttpClientObserve;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.http.client.HttpClientSecure;
import reactor.netty.http.client.HttpClientTcpConfig;
import reactor.netty.http.client.WebsocketFinalizer;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpClient;

public abstract class HttpClient {
    public static final String USER_AGENT = String.format("ReactorNetty/%s", HttpClient.reactorNettyVersion());
    static final String WS_SCHEME = "ws";
    static final String WSS_SCHEME = "wss";
    static final String HTTP_SCHEME = "http";
    static final String HTTPS_SCHEME = "https";
    static final TcpClient DEFAULT_TCP_CLIENT = TcpClient.newConnection().port(80);
    static final LoggingHandler LOGGING_HANDLER = new LoggingHandler(HttpClient.class);
    static final Function<TcpClient, TcpClient> COMPRESS_ATTR_CONFIG = tcp -> tcp.bootstrap(HttpClientConfiguration.MAP_COMPRESS);
    static final Function<TcpClient, TcpClient> COMPRESS_ATTR_DISABLE = tcp -> tcp.bootstrap(HttpClientConfiguration.MAP_NO_COMPRESS);
    static final Function<TcpClient, TcpClient> CHUNKED_ATTR_CONFIG = tcp -> tcp.bootstrap(HttpClientConfiguration.MAP_CHUNKED);
    static final Function<TcpClient, TcpClient> KEEPALIVE_ATTR_CONFIG = tcp -> tcp.bootstrap(HttpClientConfiguration.MAP_KEEPALIVE);
    static final Function<TcpClient, TcpClient> KEEPALIVE_ATTR_DISABLE = tcp -> tcp.bootstrap(HttpClientConfiguration.MAP_NO_KEEPALIVE);
    static final Function<TcpClient, TcpClient> CHUNKED_ATTR_DISABLE = tcp -> tcp.bootstrap(HttpClientConfiguration.MAP_NO_CHUNKED);
    static final Function<TcpClient, TcpClient> FOLLOW_REDIRECT_ATTR_CONFIG = tcp -> tcp.bootstrap(HttpClientConfiguration.MAP_REDIRECT);
    static final Function<TcpClient, TcpClient> FOLLOW_REDIRECT_ATTR_DISABLE = tcp -> tcp.bootstrap(HttpClientConfiguration.MAP_NO_REDIRECT);
    static final Consumer<? super HttpHeaders> COMPRESS_HEADERS = h -> h.add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
    static final Consumer<? super HttpHeaders> COMPRESS_HEADERS_DISABLE = h -> {
        if (HttpClient.isCompressing(h)) {
            h.remove((CharSequence)HttpHeaderNames.ACCEPT_ENCODING);
        }
    };

    public static HttpClient create() {
        return HttpClient.create(HttpResources.get());
    }

    public static HttpClient create(ConnectionProvider connectionProvider) {
        return new HttpClientConnect(TcpClient.create(connectionProvider).port(80));
    }

    public static HttpClient newConnection() {
        return HttpClientConnect.INSTANCE;
    }

    public static HttpClient from(TcpClient tcpClient) {
        return new HttpClientConnect(tcpClient);
    }

    public final HttpClient baseUrl(String baseUrl) {
        Objects.requireNonNull(baseUrl, "baseUrl");
        return this.tcpConfiguration(tcp -> tcp.bootstrap(b -> HttpClientConfiguration.baseUrl(b, baseUrl)));
    }

    public final HttpClient addressSupplier(Supplier<? extends SocketAddress> connectAddressSupplier) {
        Objects.requireNonNull(connectAddressSupplier, "connectAddressSupplier");
        return this.tcpConfiguration(tcpClient -> tcpClient.addressSupplier(connectAddressSupplier));
    }

    public final HttpClient compress(boolean compressionEnabled) {
        if (compressionEnabled) {
            return this.tcpConfiguration(COMPRESS_ATTR_CONFIG).headers(COMPRESS_HEADERS);
        }
        return this.tcpConfiguration(COMPRESS_ATTR_DISABLE).headers(COMPRESS_HEADERS_DISABLE);
    }

    public final HttpClient chunkedTransfer(boolean chunkedEnabled) {
        if (chunkedEnabled) {
            return this.tcpConfiguration(CHUNKED_ATTR_CONFIG);
        }
        return this.tcpConfiguration(CHUNKED_ATTR_DISABLE);
    }

    public final HttpClient cookie(Cookie cookie) {
        return new HttpClientCookie(this, cookie);
    }

    public final HttpClient cookie(String name, Consumer<? super Cookie> cookieBuilder) {
        return new HttpClientCookie(this, name, cookieBuilder);
    }

    public final HttpClient cookiesWhen(String name, Function<? super Cookie, Mono<? extends Cookie>> cookieBuilder) {
        return new HttpClientCookieWhen(this, name, cookieBuilder);
    }

    public final HttpClient cookieCodec(ClientCookieEncoder encoder) {
        ClientCookieDecoder decoder = encoder == ClientCookieEncoder.LAX ? ClientCookieDecoder.LAX : ClientCookieDecoder.STRICT;
        return this.cookieCodec(encoder, decoder);
    }

    public final HttpClient cookieCodec(ClientCookieEncoder encoder, ClientCookieDecoder decoder) {
        return this.tcpConfiguration(tcp -> tcp.bootstrap(b -> HttpClientConfiguration.cookieCodec(b, encoder, decoder)));
    }

    public final RequestSender delete() {
        return this.request(HttpMethod.DELETE);
    }

    public final HttpClient doOnRequest(BiConsumer<? super HttpClientRequest, ? super Connection> doOnRequest) {
        return new HttpClientDoOn(this, doOnRequest, null, null, null);
    }

    public final HttpClient doAfterRequest(BiConsumer<? super HttpClientRequest, ? super Connection> doAfterRequest) {
        return new HttpClientDoOn(this, null, doAfterRequest, null, null);
    }

    public final HttpClient doOnResponse(BiConsumer<? super HttpClientResponse, ? super Connection> doOnResponse) {
        return new HttpClientDoOn(this, null, null, doOnResponse, null);
    }

    public final HttpClient doAfterResponse(BiConsumer<? super HttpClientResponse, ? super Connection> doAfterResponse) {
        return new HttpClientDoOn(this, null, null, null, doAfterResponse);
    }

    public final ResponseReceiver<?> get() {
        return this.request(HttpMethod.GET);
    }

    public final ResponseReceiver<?> head() {
        return this.request(HttpMethod.HEAD);
    }

    public final HttpClient headers(Consumer<? super HttpHeaders> headerBuilder) {
        return new HttpClientHeaders(this, headerBuilder);
    }

    public final HttpClient headersWhen(Function<? super HttpHeaders, Mono<? extends HttpHeaders>> headerBuilder) {
        return new HttpClientHeadersWhen(this, headerBuilder);
    }

    public final HttpClient keepAlive(boolean keepAlive) {
        if (keepAlive) {
            return this.tcpConfiguration(KEEPALIVE_ATTR_CONFIG);
        }
        return this.tcpConfiguration(KEEPALIVE_ATTR_DISABLE);
    }

    public final HttpClient followRedirect(boolean followRedirect) {
        if (followRedirect) {
            return this.tcpConfiguration(FOLLOW_REDIRECT_ATTR_CONFIG);
        }
        return this.tcpConfiguration(FOLLOW_REDIRECT_ATTR_DISABLE);
    }

    public final HttpClient observe(ConnectionObserver observer) {
        return new HttpClientObserve(this, observer);
    }

    public final ResponseReceiver<?> options() {
        return this.request(HttpMethod.OPTIONS);
    }

    public final RequestSender patch() {
        return this.request(HttpMethod.PATCH);
    }

    public final HttpClient port(int port) {
        return this.tcpConfiguration(tcpClient -> tcpClient.port(port));
    }

    public final RequestSender post() {
        return this.request(HttpMethod.POST);
    }

    public final HttpClient protocol(HttpProtocol ... supportedProtocols) {
        return this.tcpConfiguration(tcpClient -> tcpClient.bootstrap(b -> HttpClientConfiguration.protocols(b, supportedProtocols)));
    }

    public final RequestSender put() {
        return this.request(HttpMethod.PUT);
    }

    public RequestSender request(HttpMethod method) {
        Objects.requireNonNull(method, "method");
        TcpClient tcpConfiguration = this.tcpConfiguration().bootstrap(b -> HttpClientConfiguration.method(b, method));
        return new HttpClientFinalizer(tcpConfiguration);
    }

    public final HttpClient secure() {
        return new HttpClientSecure(this, null);
    }

    public final HttpClient secure(Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        return HttpClientSecure.secure(this, sslProviderBuilder);
    }

    public final HttpClient tcpConfiguration(Function<? super TcpClient, ? extends TcpClient> tcpMapper) {
        return new HttpClientTcpConfig(this, tcpMapper);
    }

    public final HttpClient wiretap() {
        return this.tcpConfiguration(tcpClient -> tcpClient.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, LOGGING_HANDLER)));
    }

    public final WebsocketSender websocket() {
        return this.websocket("");
    }

    public final WebsocketSender websocket(String subprotocols) {
        return this.websocket(subprotocols, 65536);
    }

    public final WebsocketSender websocket(int maxFramePayloadLength) {
        return this.websocket("", maxFramePayloadLength);
    }

    public final WebsocketSender websocket(String subprotocols, int maxFramePayloadLength) {
        Objects.requireNonNull(subprotocols, "subprotocols");
        TcpClient tcpConfiguration = this.tcpConfiguration().bootstrap(b -> HttpClientConfiguration.websocketSubprotocols(b, subprotocols)).bootstrap(b -> HttpClientConfiguration.websocketMaxFramePayloadLength(b, maxFramePayloadLength));
        return new WebsocketFinalizer(tcpConfiguration);
    }

    protected TcpClient tcpConfiguration() {
        return DEFAULT_TCP_CLIENT;
    }

    static String reactorNettyVersion() {
        return Optional.ofNullable(HttpClient.class.getPackage().getImplementationVersion()).orElse("dev");
    }

    static boolean isCompressing(HttpHeaders h) {
        return h.contains((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (CharSequence)HttpHeaderValues.GZIP, true);
    }

    public static interface WebsocketReceiver<S extends WebsocketReceiver<?>>
    extends UriConfiguration<S> {
        public Mono<? extends Connection> connect();

        public <V> Flux<V> handle(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<V>> var1);

        public ByteBufFlux receive();
    }

    public static interface ResponseReceiver<S extends ResponseReceiver<?>>
    extends UriConfiguration<S> {
        public Mono<HttpClientResponse> response();

        public <V> Flux<V> response(BiFunction<? super HttpClientResponse, ? super ByteBufFlux, ? extends Publisher<V>> var1);

        public <V> Flux<V> responseConnection(BiFunction<? super HttpClientResponse, ? super Connection, ? extends Publisher<V>> var1);

        public ByteBufFlux responseContent();

        public <V> Mono<V> responseSingle(BiFunction<? super HttpClientResponse, ? super ByteBufMono, ? extends Mono<V>> var1);
    }

    public static interface WebsocketSender
    extends WebsocketReceiver<WebsocketSender> {
        public WebsocketReceiver<?> send(Function<? super HttpClientRequest, ? extends Publisher<Void>> var1);
    }

    public static interface RequestSender
    extends ResponseReceiver<RequestSender> {
        public ResponseReceiver<?> send(Publisher<? extends ByteBuf> var1);

        public ResponseReceiver<?> send(BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> var1);

        default public ResponseReceiver<?> sendForm(BiConsumer<? super HttpClientRequest, HttpClientForm> formCallback) {
            return this.sendForm(formCallback, null);
        }

        public ResponseReceiver<?> sendForm(BiConsumer<? super HttpClientRequest, HttpClientForm> var1, @Nullable Consumer<Flux<Long>> var2);
    }

    public static interface UriConfiguration<S extends UriConfiguration<?>> {
        public S uri(String var1);

        public S uri(Mono<String> var1);
    }
}

