/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.netty.http.server.HAProxyMessageReader;
import reactor.netty.tcp.InetSocketAddressUtil;

final class ConnectionInfo {
    static final String FORWARDED_HEADER = "Forwarded";
    static final Pattern FORWARDED_HOST_PATTERN = Pattern.compile("host=\"?([^;,\"]+)\"?");
    static final Pattern FORWARDED_PROTO_PATTERN = Pattern.compile("proto=\"?([^;,\"]+)\"?");
    static final Pattern FORWARDED_FOR_PATTERN = Pattern.compile("for=\"?([^;,\"]+)\"?");
    static final Pattern PORT_PATTERN = Pattern.compile("\\d*");
    static final String XFORWARDED_IP_HEADER = "X-Forwarded-For";
    static final String XFORWARDED_HOST_HEADER = "X-Forwarded-Host";
    static final String XFORWARDED_PORT_HEADER = "X-Forwarded-Port";
    static final String XFORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    static final AttributeKey<InetSocketAddress> REMOTE_ADDRESS_FROM_PROXY_PROTOCOL = AttributeKey.valueOf((String)"remoteAddressFromProxyProtocol");
    final InetSocketAddress hostAddress;
    final InetSocketAddress remoteAddress;
    final String scheme;

    static ConnectionInfo from(Channel channel, boolean headers, HttpRequest request, boolean secured) {
        if (headers) {
            return ConnectionInfo.newForwardedConnectionInfo(request, channel, secured);
        }
        return ConnectionInfo.newConnectionInfo(channel, secured);
    }

    static ConnectionInfo newConnectionInfo(Channel c, boolean secured) {
        SocketChannel channel = (SocketChannel)c;
        InetSocketAddress hostAddress = channel.localAddress();
        InetSocketAddress remoteAddress = ConnectionInfo.getRemoteAddress(channel);
        String scheme = secured ? "https" : "http";
        return new ConnectionInfo(hostAddress, remoteAddress, scheme);
    }

    static ConnectionInfo newForwardedConnectionInfo(HttpRequest request, Channel channel, boolean secured) {
        if (request.headers().contains(FORWARDED_HEADER)) {
            return ConnectionInfo.parseForwardedInfo(request, (SocketChannel)channel, secured);
        }
        return ConnectionInfo.parseXForwardedInfo(request, (SocketChannel)channel, secured);
    }

    static ConnectionInfo parseForwardedInfo(HttpRequest request, SocketChannel channel, boolean secured) {
        Matcher forMatcher;
        Matcher protoMatcher;
        InetSocketAddress hostAddress = channel.localAddress();
        InetSocketAddress remoteAddress = ConnectionInfo.getRemoteAddress(channel);
        String scheme = secured ? "https" : "http";
        String forwarded = request.headers().get(FORWARDED_HEADER).split(",")[0];
        Matcher hostMatcher = FORWARDED_HOST_PATTERN.matcher(forwarded);
        if (hostMatcher.find()) {
            hostAddress = ConnectionInfo.parseAddress(hostMatcher.group(1), hostAddress.getPort());
        }
        if ((protoMatcher = FORWARDED_PROTO_PATTERN.matcher(forwarded)).find()) {
            scheme = protoMatcher.group(1).trim();
        }
        if ((forMatcher = FORWARDED_FOR_PATTERN.matcher(forwarded)).find()) {
            remoteAddress = ConnectionInfo.parseAddress(forMatcher.group(1).trim(), remoteAddress.getPort());
        }
        return new ConnectionInfo(hostAddress, remoteAddress, scheme);
    }

    static InetSocketAddress parseAddress(String address, int defaultPort) {
        int ipV6HostSeparatorIdx;
        int separatorIdx = address.lastIndexOf(":");
        if (separatorIdx > (ipV6HostSeparatorIdx = address.lastIndexOf("]")) && (separatorIdx == address.indexOf(":") || ipV6HostSeparatorIdx > -1)) {
            String port = address.substring(separatorIdx + 1);
            if (PORT_PATTERN.matcher(port).matches()) {
                return InetSocketAddressUtil.createUnresolved(address.substring(0, separatorIdx), Integer.parseInt(port));
            }
            return InetSocketAddressUtil.createUnresolved(address.substring(0, separatorIdx), defaultPort);
        }
        return InetSocketAddressUtil.createUnresolved(address, defaultPort);
    }

    static ConnectionInfo parseXForwardedInfo(HttpRequest request, SocketChannel channel, boolean secured) {
        String scheme;
        InetSocketAddress hostAddress = channel.localAddress();
        InetSocketAddress remoteAddress = ConnectionInfo.getRemoteAddress(channel);
        String string = scheme = secured ? "https" : "http";
        if (request.headers().contains(XFORWARDED_IP_HEADER)) {
            String remoteIpValue = request.headers().get(XFORWARDED_IP_HEADER).split(",")[0];
            remoteAddress = ConnectionInfo.parseAddress(remoteIpValue, remoteAddress.getPort());
        }
        if (request.headers().contains(XFORWARDED_HOST_HEADER)) {
            hostAddress = request.headers().contains(XFORWARDED_PORT_HEADER) ? InetSocketAddressUtil.createUnresolved(request.headers().get(XFORWARDED_HOST_HEADER).split(",")[0].trim(), Integer.parseInt(request.headers().get(XFORWARDED_PORT_HEADER).split(",")[0].trim())) : InetSocketAddressUtil.createUnresolved(request.headers().get(XFORWARDED_HOST_HEADER).split(",")[0].trim(), channel.localAddress().getPort());
        }
        if (request.headers().contains(XFORWARDED_PROTO_HEADER)) {
            scheme = request.headers().get(XFORWARDED_PROTO_HEADER).trim();
        }
        return new ConnectionInfo(hostAddress, remoteAddress, scheme);
    }

    private static InetSocketAddress getRemoteAddress(SocketChannel channel) {
        InetSocketAddress remoteAddressFromProxyProtocol;
        if (HAProxyMessageReader.hasProxyProtocol() && (remoteAddressFromProxyProtocol = (InetSocketAddress)channel.attr(REMOTE_ADDRESS_FROM_PROXY_PROTOCOL).getAndSet(null)) != null) {
            return remoteAddressFromProxyProtocol;
        }
        return channel.remoteAddress();
    }

    ConnectionInfo(InetSocketAddress hostAddress, InetSocketAddress remoteAddress, String scheme) {
        this.hostAddress = hostAddress;
        this.remoteAddress = remoteAddress;
        this.scheme = scheme;
    }

    InetSocketAddress getHostAddress() {
        return this.hostAddress;
    }

    InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    String getScheme() {
        return this.scheme;
    }
}

