/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.websocket;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import reactor.core.publisher.Flux;
import reactor.netty.NettyInbound;
import reactor.util.annotation.Nullable;

public interface WebsocketInbound
extends NettyInbound {
    @Nullable
    public String selectedSubprotocol();

    public HttpHeaders headers();

    default public WebsocketInbound aggregateFrames() {
        return this.aggregateFrames(65536);
    }

    default public WebsocketInbound aggregateFrames(int maxContentLength) {
        this.withConnection(c -> c.addHandlerLast((ChannelHandler)new WebSocketFrameAggregator(maxContentLength)));
        return this;
    }

    default public Flux<WebSocketFrame> receiveFrames() {
        return this.receiveObject().ofType(WebSocketFrame.class);
    }
}

