/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import java.net.SocketAddress;
import java.time.Duration;
import javax.annotation.Nullable;
import reactor.netty.Metrics;
import reactor.netty.http.MicrometerHttpMetricsRecorder;
import reactor.netty.http.client.HttpClientMetricsRecorder;

final class MicrometerHttpClientMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpClientMetricsRecorder {
    MicrometerHttpClientMetricsRecorder(String name, @Nullable String remoteAddress, String protocol) {
        super(name, remoteAddress, protocol);
    }

    @Override
    public void recordDataReceivedTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        this.dataReceivedTimeBuilder.tags(new String[]{"remote.address", Metrics.formatSocketAddress(remoteAddress), "uri", uri, "method", method, "status", status}).register(registry).record(time);
    }

    @Override
    public void recordDataSentTime(SocketAddress remoteAddress, String uri, String method, Duration time) {
        this.dataSentTimeBuilder.tags(new String[]{"remote.address", Metrics.formatSocketAddress(remoteAddress), "uri", uri, "method", method}).register(registry).record(time);
    }

    @Override
    public void recordResponseTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        this.responseTimeBuilder.tags(new String[]{"remote.address", Metrics.formatSocketAddress(remoteAddress), "uri", uri, "method", method, "status", status}).register(registry).record(time);
    }
}

