/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.Optional;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HAProxyMessageReader;
import reactor.netty.http.server.HttpServerOperations;

final class Http2StreamBridgeHandler
extends ChannelDuplexHandler {
    final boolean readForwardHeaders;
    Boolean secured;
    InetSocketAddress remoteAddress;
    final ConnectionObserver listener;
    final ServerCookieEncoder cookieEncoder;
    final ServerCookieDecoder cookieDecoder;

    Http2StreamBridgeHandler(ConnectionObserver listener, boolean readForwardHeaders, ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        this.readForwardHeaders = readForwardHeaders;
        this.listener = listener;
        this.cookieEncoder = encoder;
        this.cookieDecoder = decoder;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "New http2 connection, requesting read"));
        }
        ctx.read();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.secured == null) {
            this.secured = ctx.channel().parent().pipeline().get(SslHandler.class) != null;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(HAProxyMessageReader.resolveRemoteAddressFromProxyProtocol(ctx.channel().parent())).orElse(((SocketChannel)ctx.channel().parent()).remoteAddress());
        }
        if (msg instanceof HttpRequest) {
            HttpServerOperations ops;
            HttpRequest request = (HttpRequest)msg;
            try {
                ops = new HttpServerOperations(Connection.from(ctx.channel()), this.listener, null, request, ConnectionInfo.from(ctx.channel().parent(), this.readForwardHeaders, request, this.secured, this.remoteAddress), this.cookieEncoder, this.cookieDecoder);
            }
            catch (RuntimeException e) {
                HttpServerOperations.sendDecodingFailures(ctx, e, msg);
                return;
            }
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ctx.write((Object)new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            ctx.write(msg, promise);
        }
    }
}

