/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.FutureMono;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.Cookies;
import reactor.netty.http.HttpOperations;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpServerState;
import reactor.netty.http.server.SimpleCompressionHandler;
import reactor.netty.http.server.WebsocketServerOperations;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

class HttpServerOperations
extends HttpOperations<HttpServerRequest, HttpServerResponse>
implements HttpServerRequest,
HttpServerResponse {
    final HttpResponse nettyResponse;
    final HttpHeaders responseHeaders;
    final Cookies cookieHolder;
    final HttpRequest nettyRequest;
    final String path;
    final ConnectionInfo connectionInfo;
    final ServerCookieEncoder cookieEncoder;
    final ServerCookieDecoder cookieDecoder;
    final BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate;
    Function<? super String, Map<String, String>> paramsResolver;
    static final Logger log = Loggers.getLogger(HttpServerOperations.class);
    static final AsciiString EVENT_STREAM = new AsciiString((CharSequence)"text/event-stream");
    static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);

    HttpServerOperations(HttpServerOperations replaced) {
        super(replaced);
        this.cookieHolder = replaced.cookieHolder;
        this.connectionInfo = replaced.connectionInfo;
        this.responseHeaders = replaced.responseHeaders;
        this.nettyResponse = replaced.nettyResponse;
        this.paramsResolver = replaced.paramsResolver;
        this.nettyRequest = replaced.nettyRequest;
        this.path = replaced.path;
        this.compressionPredicate = replaced.compressionPredicate;
        this.cookieEncoder = replaced.cookieEncoder;
        this.cookieDecoder = replaced.cookieDecoder;
    }

    HttpServerOperations(Connection c, ConnectionObserver listener, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, HttpRequest nettyRequest, ConnectionInfo connectionInfo, ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        super(c, listener);
        this.nettyRequest = nettyRequest;
        this.path = HttpServerOperations.resolvePath(nettyRequest.uri());
        this.nettyResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.responseHeaders = this.nettyResponse.headers();
        this.responseHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        this.compressionPredicate = compressionPredicate;
        this.cookieHolder = Cookies.newServerRequestHolder(this.requestHeaders(), decoder);
        this.connectionInfo = connectionInfo;
        this.cookieEncoder = encoder;
        this.cookieDecoder = decoder;
    }

    @Override
    public NettyOutbound sendHeaders() {
        if (this.hasSentHeaders()) {
            return this;
        }
        return this.then((Publisher<Void>)Mono.empty());
    }

    @Override
    public HttpServerOperations withConnection(Consumer<? super Connection> withConnection) {
        Objects.requireNonNull(withConnection, "withConnection");
        withConnection.accept(this);
        return this;
    }

    @Override
    protected HttpMessage newFullBodyMessage(ByteBuf body) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(this.version(), this.status(), body);
        this.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        if (!HttpResponseStatus.NOT_MODIFIED.equals((Object)this.status()) && HttpUtil.getContentLength((HttpMessage)this.nettyResponse, (int)-1) == -1) {
            this.responseHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, body.readableBytes());
        }
        res.headers().set(this.responseHeaders);
        return res;
    }

    @Override
    public HttpServerResponse addCookie(Cookie cookie) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)this.cookieEncoder.encode(cookie));
        return this;
    }

    @Override
    public HttpServerResponse addHeader(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerOperations chunkedTransfer(boolean chunked) {
        if (!this.hasSentHeaders() && HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyResponse) != chunked) {
            this.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.nettyResponse, (boolean)chunked);
        }
        return this;
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        if (this.cookieHolder != null) {
            return this.cookieHolder.getCachedCookies();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpServerResponse header(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerResponse headers(HttpHeaders headers) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.set(headers);
        return this;
    }

    @Override
    public boolean isKeepAlive() {
        return HttpUtil.isKeepAlive((HttpMessage)this.nettyRequest);
    }

    @Override
    public boolean isWebsocket() {
        return HttpServerOperations.get(this.channel()) instanceof WebsocketServerOperations;
    }

    boolean isHttp2() {
        return this.requestHeaders().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text());
    }

    @Override
    public HttpServerResponse keepAlive(boolean keepAlive) {
        HttpUtil.setKeepAlive((HttpMessage)this.nettyResponse, (boolean)keepAlive);
        return this;
    }

    @Override
    public HttpMethod method() {
        return this.nettyRequest.method();
    }

    @Override
    @Nullable
    public String param(CharSequence key) {
        Objects.requireNonNull(key, "key");
        Map<String, String> params = null;
        if (this.paramsResolver != null) {
            params = this.paramsResolver.apply(this.uri());
        }
        return null != params ? params.get(key.toString()) : null;
    }

    @Override
    @Nullable
    public Map<String, String> params() {
        return null != this.paramsResolver ? this.paramsResolver.apply(this.uri()) : null;
    }

    @Override
    public HttpServerRequest paramsResolver(Function<? super String, Map<String, String>> paramsResolver) {
        this.paramsResolver = paramsResolver;
        return this;
    }

    @Override
    public Flux<?> receiveObject() {
        if (HttpUtil.is100ContinueExpected((HttpMessage)this.nettyRequest)) {
            return FutureMono.deferFuture(() -> {
                if (!this.hasSentHeaders()) {
                    return this.channel().writeAndFlush((Object)CONTINUE);
                }
                return this.channel().newSucceededFuture();
            }).thenMany(super.receiveObject());
        }
        return super.receiveObject();
    }

    @Override
    public InetSocketAddress hostAddress() {
        return this.connectionInfo.getHostAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.connectionInfo.getRemoteAddress();
    }

    @Override
    public HttpHeaders requestHeaders() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.headers();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public String scheme() {
        return this.connectionInfo.getScheme();
    }

    @Override
    public HttpHeaders responseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public Mono<Void> send() {
        if (this.markSentHeaderAndBody(new Object[0])) {
            HttpMessage response = this.newFullBodyMessage(Unpooled.EMPTY_BUFFER);
            return FutureMono.deferFuture(() -> this.channel().writeAndFlush((Object)response));
        }
        return Mono.empty();
    }

    @Override
    public NettyOutbound sendFile(Path file) {
        try {
            return this.sendFile(file, 0L, Files.size(file));
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Path not resolved"), (Throwable)e);
            }
            return this.then((Publisher<Void>)this.sendNotFound());
        }
    }

    @Override
    public Mono<Void> sendNotFound() {
        return this.status(HttpResponseStatus.NOT_FOUND).send();
    }

    @Override
    public Mono<Void> sendRedirect(String location) {
        Objects.requireNonNull(location, "location");
        return this.status(HttpResponseStatus.FOUND).header((CharSequence)HttpHeaderNames.LOCATION, location).send();
    }

    @Override
    public HttpServerResponse sse() {
        this.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)EVENT_STREAM);
        return this;
    }

    @Override
    public HttpResponseStatus status() {
        return this.nettyResponse.status();
    }

    @Override
    public HttpServerResponse status(HttpResponseStatus status) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.nettyResponse.setStatus(status);
        return this;
    }

    @Override
    public Mono<Void> sendWebsocket(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler, WebsocketServerSpec configurer) {
        return this.withWebsocketSupport(this.uri(), configurer, websocketHandler);
    }

    @Override
    public String uri() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.uri();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public String fullPath() {
        if (this.path != null) {
            return this.path;
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpVersion version() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.protocolVersion();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpServerResponse compression(boolean compress) {
        if (!compress) {
            this.removeHandler("reactor.left.compressionHandler");
        } else if (this.channel().pipeline().get("reactor.left.compressionHandler") == null) {
            SimpleCompressionHandler handler = new SimpleCompressionHandler();
            try {
                ArrayList<Object> out = new ArrayList<Object>();
                try {
                    handler.decode(this.channel().pipeline().context("reactor.right.reactiveBridge"), this.nettyRequest, out);
                }
                catch (DecoderException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DecoderException((Throwable)e);
                }
                finally {
                    ReferenceCountUtil.release((Object)this.nettyRequest);
                    out.clear();
                }
                this.addHandlerFirst("reactor.left.compressionHandler", (ChannelHandler)handler);
            }
            catch (Throwable e) {
                log.error(ReactorNetty.format(this.channel(), ""), e);
            }
        }
        return this;
    }

    @Override
    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            try {
                this.listener().onStateChange(this, HttpServerState.REQUEST_RECEIVED);
            }
            catch (Exception e) {
                this.onInboundError(e);
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (msg instanceof FullHttpRequest) {
                FullHttpRequest request = (FullHttpRequest)msg;
                if (request.content().readableBytes() > 0) {
                    super.onInboundNext(ctx, msg);
                } else {
                    request.release();
                }
                if (this.isHttp2()) {
                    this.channel().config().setAutoRead(true);
                    this.onInboundComplete();
                }
            }
            return;
        }
        if (msg instanceof HttpContent) {
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                super.onInboundNext(ctx, msg);
            }
            if (msg instanceof LastHttpContent) {
                this.channel().config().setAutoRead(true);
                this.onInboundComplete();
            }
        } else {
            super.onInboundNext(ctx, msg);
        }
    }

    @Override
    protected void afterMarkSentHeaders() {
        if (HttpResponseStatus.NOT_MODIFIED.equals((Object)this.status())) {
            this.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING).remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        }
        if (this.compressionPredicate != null && this.compressionPredicate.test(this, this)) {
            this.compression(true);
        }
    }

    @Override
    protected void beforeMarkSentHeaders() {
    }

    @Override
    protected void onOutboundComplete() {
        ChannelFuture f;
        if (this.isWebsocket()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "Last HTTP response frame"));
        }
        if (this.markSentHeaderAndBody(new Object[0])) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "No sendHeaders() called before complete, sending zero-length header"));
            }
            f = this.channel().writeAndFlush((Object)this.newFullBodyMessage(Unpooled.EMPTY_BUFFER));
        } else if (this.markSentBody()) {
            f = this.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            this.discard();
            return;
        }
        f.addListener(s -> {
            this.discard();
            if (!s.isSuccess() && log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Failed flushing last frame"), s.cause());
            }
        });
    }

    static void cleanHandlerTerminate(Channel ch) {
        ChannelOperations<?, ?> ops = HttpServerOperations.get(ch);
        if (ops == null) {
            return;
        }
        ops.discard();
        if (!ops.isSubscriptionDisposed()) {
            ch.eventLoop().execute(((HttpServerOperations)ops)::terminate);
        } else {
            ((HttpServerOperations)ops).terminate();
        }
    }

    static void sendDecodingFailures(ChannelHandlerContext ctx, Throwable t, Object msg) {
        Throwable cause;
        Throwable throwable = cause = t.getCause() != null ? t.getCause() : t;
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(ctx.channel(), "Decoding failed: " + msg + " : "), cause);
        }
        ReferenceCountUtil.release((Object)msg);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_0, cause instanceof TooLongFrameException ? HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE : HttpResponseStatus.BAD_REQUEST);
        response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (!this.channel().isActive()) {
            super.onOutboundError(err);
            return;
        }
        if (this.markSentHeaders(new Object[0])) {
            log.error(ReactorNetty.format(this.channel(), "Error starting response. Replying error status"), err);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            response.headers().set(this.responseHeaders).remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING).setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            this.channel().writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        this.markSentBody();
        log.error(ReactorNetty.format(this.channel(), "Error finishing response. Closing connection"), err);
        this.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    @Override
    protected HttpMessage outboundHttpMessage() {
        return this.nettyResponse;
    }

    final Mono<Void> withWebsocketSupport(String url, WebsocketServerSpec websocketServerSpec, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        Objects.requireNonNull(websocketServerSpec, "websocketServerSpec");
        Objects.requireNonNull(websocketHandler, "websocketHandler");
        if (this.markSentHeaders(new Object[0])) {
            WebsocketServerOperations ops = new WebsocketServerOperations(url, websocketServerSpec, this);
            return FutureMono.from(ops.handshakerResult).doOnEach(signal -> {
                if (!(signal.hasError() || websocketServerSpec.protocols() != null && ops.selectedSubprotocol() == null)) {
                    ((Publisher)websocketHandler.apply(ops, ops)).subscribe((Subscriber)new WebsocketSubscriber(ops, signal.getContext()));
                }
            });
        }
        log.error(ReactorNetty.format(this.channel(), "Cannot enable websocket if headers have already been sent"));
        return Mono.error((Throwable)new IllegalStateException("Failed to upgrade to websocket"));
    }

    static final class WebsocketSubscriber
    implements CoreSubscriber<Void>,
    ChannelFutureListener {
        final WebsocketServerOperations ops;
        final Context context;

        WebsocketSubscriber(WebsocketServerOperations ops, Context context) {
            this.ops = ops;
            this.context = context;
        }

        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
        }

        public void onNext(Void aVoid) {
        }

        public void onError(Throwable t) {
            this.ops.onError(t);
        }

        public void operationComplete(ChannelFuture future) {
            ((HttpServerOperations)this.ops).terminate();
        }

        public void onComplete() {
            if (this.ops.channel().isActive()) {
                this.ops.sendCloseNow(null, this);
            }
        }

        public Context currentContext() {
            return this.context;
        }
    }
}

