/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.MonoSend;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

final class MonoSendMany<I, O>
extends MonoSend<I, O>
implements Scannable {
    final Publisher<? extends I> source;
    final Predicate<I> predicate;

    static MonoSendMany<ByteBuf, ByteBuf> byteBufSource(Publisher<? extends ByteBuf> source, Channel channel, Predicate<ByteBuf> predicate) {
        return new MonoSendMany<ByteBuf, ByteBuf>(source, channel, predicate, TRANSFORMATION_FUNCTION_BB, CONSUMER_BB_NOCHECK_CLEANUP, SIZE_OF_BB);
    }

    static MonoSendMany<?, ?> objectSource(Publisher<?> source, Channel channel, Predicate<Object> predicate) {
        return new MonoSendMany(source, channel, predicate, TRANSFORMATION_FUNCTION, CONSUMER_NOCHECK_CLEANUP, SIZE_OF);
    }

    MonoSendMany(Publisher<? extends I> source, Channel channel, Predicate<I> predicate, Function<? super I, ? extends O> transformer, Consumer<? super I> sourceCleanup, ToIntFunction<O> sizeOf) {
        super(channel, transformer, sourceCleanup, sizeOf);
        this.source = Objects.requireNonNull(source, "source publisher cannot be null");
        this.predicate = Objects.requireNonNull(predicate, "predicate cannot be null");
    }

    public void subscribe(CoreSubscriber<? super Void> destination) {
        this.source.subscribe(new SendManyInner(this, destination));
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return 128;
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }

    static final class Completion
    extends Exception {
        static final Completion INSTANCE = new Completion();

        Completion() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class SendManyInner<I, O>
    implements CoreSubscriber<I>,
    Subscription,
    Fuseable,
    ChannelFutureListener,
    Runnable,
    Scannable,
    ChannelPromise {
        final ChannelHandlerContext ctx;
        final EventLoop eventLoop;
        final MonoSendMany<I, O> parent;
        final CoreSubscriber<? super Void> actual;
        final Runnable asyncFlush;
        volatile Subscription s;
        volatile int wip;
        Queue<I> queue;
        int pending;
        int requested;
        int sourceMode;
        boolean needFlush;
        Throwable terminalSignal;
        int nextRequest;
        static final AtomicIntegerFieldUpdater<SendManyInner> WIP = AtomicIntegerFieldUpdater.newUpdater(SendManyInner.class, "wip");
        static final AtomicReferenceFieldUpdater<SendManyInner, Subscription> SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(SendManyInner.class, Subscription.class, "s");

        SendManyInner(MonoSendMany<I, O> parent, CoreSubscriber<? super Void> actual) {
            this.parent = parent;
            this.actual = actual;
            this.requested = 128;
            this.ctx = parent.ctx;
            this.eventLoop = this.ctx.channel().eventLoop();
            this.asyncFlush = new AsyncFlush();
            this.ctx.channel().closeFuture().addListener((GenericFutureListener)this);
        }

        public Context currentContext() {
            return this.actual.currentContext();
        }

        public void cancel() {
            if (!Operators.terminate(SUBSCRIPTION, (Object)this)) {
                return;
            }
            if (WIP.getAndIncrement(this) == 0) {
                this.onInterruptionCleanup();
            }
        }

        public void onComplete() {
            if (this.terminalSignal != null) {
                return;
            }
            this.terminalSignal = Completion.INSTANCE;
            this.trySchedule(null);
        }

        public void onError(Throwable t) {
            if (this.terminalSignal != null) {
                Operators.onErrorDropped((Throwable)t, (Context)this.actual.currentContext());
                return;
            }
            if (t instanceof ClosedChannelException) {
                t = ReactorNetty.wrapException(t);
            }
            this.terminalSignal = t;
            this.trySchedule(null);
        }

        public void onNext(I t) {
            if (this.sourceMode == 2) {
                this.trySchedule(null);
                return;
            }
            if (this.terminalSignal != null) {
                this.parent.sourceCleanup.accept(t);
                Operators.onDiscard(t, (Context)this.actual.currentContext());
                return;
            }
            if (!this.queue.offer(t)) {
                this.onError(Operators.onOperatorError((Subscription)this.s, (Throwable)Exceptions.failWithOverflow((String)"Queue is full: Reactive Streams source doesn't respect backpressure"), t, (Context)this.actual.currentContext()));
                return;
            }
            this.trySchedule(t);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(SUBSCRIPTION, (Object)this, (Subscription)s)) {
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription f = (Fuseable.QueueSubscription)s;
                    int m = f.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.terminalSignal = Completion.INSTANCE;
                        this.actual.onSubscribe((Subscription)this);
                        this.trySchedule(null);
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                        this.actual.onSubscribe((Subscription)this);
                        s.request(128L);
                        return;
                    }
                }
                this.queue = (Queue)Queues.get((int)128).get();
                this.actual.onSubscribe((Subscription)this);
                s.request(128L);
            } else {
                this.queue = (Queue)Queues.empty().get();
            }
        }

        public void request(long n) {
        }

        public void operationComplete(ChannelFuture future) {
            if (Operators.terminate(SUBSCRIPTION, (Object)this)) {
                if (WIP.getAndIncrement(this) == 0) {
                    this.onInterruptionCleanup();
                }
                this.actual.onComplete();
            }
        }

        @Override
        public void run() {
            Queue<I> queue = this.queue;
            try {
                int missed = 1;
                do {
                    I sourceMessage;
                    int r = this.requested;
                    while ((Integer.MAX_VALUE == r || r-- > 0) && (sourceMessage = queue.poll()) != null) {
                        if (this.s == Operators.cancelledSubscription()) {
                            this.parent.sourceCleanup.accept(sourceMessage);
                            Operators.onDiscard(sourceMessage, (Context)this.actual.currentContext());
                            this.onInterruptionCleanup();
                            return;
                        }
                        Object encodedMessage = this.parent.transformer.apply(sourceMessage);
                        if (encodedMessage == null) {
                            if (!this.parent.predicate.test(sourceMessage)) continue;
                            ++this.nextRequest;
                            this.needFlush = false;
                            this.ctx.flush();
                            continue;
                        }
                        int readableBytes = this.parent.sizeOf.applyAsInt(encodedMessage);
                        if (readableBytes == 0 && !(encodedMessage instanceof ByteBufHolder)) {
                            ReferenceCountUtil.release(encodedMessage);
                            ++this.nextRequest;
                            continue;
                        }
                        ++this.pending;
                        this.ctx.write(encodedMessage, (ChannelPromise)this);
                        if (this.parent.predicate.test(sourceMessage) || !this.ctx.channel().isWritable() || (long)readableBytes > this.ctx.channel().bytesBeforeUnwritable()) {
                            this.needFlush = false;
                            this.ctx.flush();
                            continue;
                        }
                        this.needFlush = true;
                    }
                    if (this.needFlush && this.pending != 0) {
                        this.needFlush = false;
                        this.eventLoop.execute(this.asyncFlush);
                    }
                    if (Operators.cancelledSubscription() == this.s) {
                        this.onInterruptionCleanup();
                        return;
                    }
                    if (this.checkTerminated() && queue.isEmpty()) {
                        this.ctx.channel().closeFuture().removeListener((GenericFutureListener)this);
                        Throwable t = this.terminalSignal;
                        if (t == Completion.INSTANCE) {
                            this.actual.onComplete();
                        } else {
                            this.actual.onError(t);
                        }
                        return;
                    }
                    int nextRequest = this.nextRequest;
                    if (this.terminalSignal != null || nextRequest == 0) continue;
                    this.nextRequest = 0;
                    this.s.request((long)nextRequest);
                } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            }
            catch (Throwable t) {
                this.onInterruptionCleanup();
                if (Operators.terminate(SUBSCRIPTION, (Object)this)) {
                    this.actual.onError(t);
                }
                Operators.onErrorDropped((Throwable)t, (Context)this.actual.currentContext());
            }
        }

        void onInterruptionCleanup() {
            this.ctx.channel().closeFuture().removeListener((GenericFutureListener)this);
            Queue<I> queue = this.queue;
            if (queue == null) {
                return;
            }
            Context context = null;
            while (!queue.isEmpty()) {
                I sourceMessage = queue.poll();
                if (sourceMessage == null) continue;
                this.parent.sourceCleanup.accept(sourceMessage);
                if (context == null) {
                    context = this.actual.currentContext();
                }
                Operators.onDiscard(sourceMessage, context);
            }
        }

        boolean checkTerminated() {
            return this.pending == 0 && this.terminalSignal != null;
        }

        void trySchedule(@Nullable Object data) {
            block4: {
                if (WIP.getAndIncrement(this) == 0) {
                    try {
                        if (this.eventLoop.inEventLoop()) {
                            this.run();
                            return;
                        }
                        this.eventLoop.execute((Runnable)this);
                    }
                    catch (Throwable t) {
                        if (!Operators.terminate(SUBSCRIPTION, (Object)this)) break block4;
                        this.onInterruptionCleanup();
                        this.actual.onError((Throwable)Operators.onRejectedExecution((Throwable)t, null, null, (Object)data, (Context)this.actual.currentContext()));
                    }
                }
            }
        }

        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return Operators.cancelledSubscription() == this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.terminalSignal != null;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.queue != null ? this.queue.size() : 0;
            }
            if (key == Scannable.Attr.ERROR) {
                return !this.hasOnComplete() ? this.terminalSignal : null;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return 128;
            }
            return null;
        }

        public Channel channel() {
            return this.ctx.channel();
        }

        public ChannelPromise setSuccess(Void result) {
            this.trySuccess(null);
            return this;
        }

        public ChannelPromise setSuccess() {
            this.trySuccess(null);
            return this;
        }

        public boolean trySuccess() {
            this.trySuccess(null);
            return true;
        }

        public ChannelPromise setFailure(Throwable cause) {
            if (this.tryFailure(cause)) {
                return this;
            }
            Operators.onErrorDropped((Throwable)cause, (Context)this.actual.currentContext());
            return this;
        }

        public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            throw new UnsupportedOperationException();
        }

        public ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            throw new UnsupportedOperationException();
        }

        public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            return this;
        }

        public ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            return this;
        }

        public ChannelPromise sync() {
            throw new UnsupportedOperationException();
        }

        public ChannelPromise syncUninterruptibly() {
            throw new UnsupportedOperationException();
        }

        public ChannelPromise await() {
            throw new UnsupportedOperationException();
        }

        public ChannelPromise awaitUninterruptibly() {
            throw new UnsupportedOperationException();
        }

        public ChannelPromise unvoid() {
            return new DefaultChannelPromise(this.ctx.channel()){

                public ChannelPromise setSuccess(Void result) {
                    super.trySuccess(null);
                    this.trySuccess(null);
                    return this;
                }

                public boolean trySuccess(Void result) {
                    super.trySuccess(null);
                    return this.trySuccess(null);
                }

                public ChannelPromise setFailure(Throwable cause) {
                    super.tryFailure(cause);
                    this.tryFailure(cause);
                    return this;
                }

                public boolean tryFailure(Throwable cause) {
                    super.tryFailure(cause);
                    return this.tryFailure(cause);
                }
            };
        }

        public boolean isVoid() {
            return false;
        }

        public boolean trySuccess(Void result) {
            --this.requested;
            --this.pending;
            if (this.checkTerminated()) {
                this.trySchedule(null);
                return true;
            }
            if (this.requested <= 64) {
                int u = 128 - this.requested;
                this.requested += u;
                this.nextRequest += u;
                this.trySchedule(null);
            }
            return true;
        }

        public boolean tryFailure(Throwable cause) {
            if (Operators.terminate(SUBSCRIPTION, (Object)this)) {
                if (WIP.getAndIncrement(this) == 0) {
                    this.onInterruptionCleanup();
                }
                this.actual.onError(cause);
            }
            return true;
        }

        public boolean setUncancellable() {
            return true;
        }

        public boolean isSuccess() {
            return this.hasOnComplete() && this.queue.isEmpty();
        }

        public boolean isCancellable() {
            return false;
        }

        @Nullable
        public Throwable cause() {
            return null;
        }

        public boolean await(long timeout, TimeUnit unit) {
            return false;
        }

        public boolean await(long timeoutMillis) {
            throw new UnsupportedOperationException();
        }

        public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public boolean awaitUninterruptibly(long timeoutMillis) {
            throw new UnsupportedOperationException();
        }

        public Void getNow() {
            throw new UnsupportedOperationException();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return false;
        }

        public Void get() {
            throw new UnsupportedOperationException();
        }

        public Void get(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        boolean hasOnComplete() {
            return this.terminalSignal == Completion.INSTANCE;
        }

        final class AsyncFlush
        implements Runnable {
            AsyncFlush() {
            }

            @Override
            public void run() {
                if (SendManyInner.this.pending != 0) {
                    SendManyInner.this.ctx.flush();
                }
            }
        }
    }
}

