/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.spec;

import reactor.Environment;
import reactor.bus.Event;
import reactor.bus.EventBus;
import reactor.bus.filter.AbstractFilter;
import reactor.bus.filter.Filter;
import reactor.bus.filter.FirstFilter;
import reactor.bus.filter.PassThroughFilter;
import reactor.bus.filter.RandomFilter;
import reactor.bus.filter.RoundRobinFilter;
import reactor.bus.filter.TraceableDelegatingFilter;
import reactor.bus.registry.Registries;
import reactor.bus.registry.Registry;
import reactor.bus.routing.ConsumerFilteringRouter;
import reactor.bus.routing.Router;
import reactor.bus.routing.TraceableDelegatingRouter;
import reactor.bus.spec.DispatcherComponentSpec;
import reactor.core.Dispatcher;
import reactor.core.dispatch.TraceableDelegatingDispatcher;
import reactor.core.support.Assert;
import reactor.fn.Consumer;

public abstract class EventRoutingComponentSpec<SPEC extends EventRoutingComponentSpec<SPEC, TARGET>, TARGET>
extends DispatcherComponentSpec<SPEC, TARGET> {
    private EventRoutingStrategy eventRoutingStrategy;
    private Router router;
    private Filter eventFilter;
    private Consumer<Throwable> dispatchErrorHandler;
    private Consumer<Throwable> uncaughtErrorHandler;
    private Registry<Object, Consumer<? extends Event<?>>> consumerRegistry;
    private boolean traceEventPath = false;

    public final SPEC eventFilter(Filter filter) {
        Assert.isNull((Object)this.router, (String)"Cannot set both a filter and a router. Use one or the other.");
        this.eventFilter = filter;
        return (SPEC)this;
    }

    public final SPEC eventRouter(Router router) {
        Assert.isNull((Object)this.eventFilter, (String)"Cannot set both a filter and a router. Use one or the other.");
        this.router = router;
        return (SPEC)this;
    }

    public final SPEC broadcastEventRouting() {
        this.eventRoutingStrategy = EventRoutingStrategy.BROADCAST;
        return (SPEC)this;
    }

    public final SPEC randomEventRouting() {
        this.eventRoutingStrategy = EventRoutingStrategy.RANDOM;
        return (SPEC)this;
    }

    public final SPEC firstEventRouting() {
        this.eventRoutingStrategy = EventRoutingStrategy.FIRST;
        return (SPEC)this;
    }

    public final SPEC roundRobinEventRouting() {
        this.eventRoutingStrategy = EventRoutingStrategy.ROUND_ROBIN;
        return (SPEC)this;
    }

    public SPEC dispatchErrorHandler(Consumer<Throwable> dispatchErrorHandler) {
        this.dispatchErrorHandler = dispatchErrorHandler;
        return (SPEC)this;
    }

    public SPEC uncaughtErrorHandler(Consumer<Throwable> uncaughtErrorHandler) {
        this.uncaughtErrorHandler = uncaughtErrorHandler;
        return (SPEC)this;
    }

    public final SPEC traceEventPath() {
        return this.traceEventPath(true);
    }

    public final SPEC traceEventPath(boolean b) {
        this.traceEventPath = b;
        return (SPEC)this;
    }

    public SPEC consumerRegistry(Registry<Object, Consumer<? extends Event<?>>> consumerRegistry) {
        this.consumerRegistry = consumerRegistry;
        return (SPEC)this;
    }

    public SPEC consumerNotFoundHandler(Consumer<Object> consumerNotFoundHandler) {
        this.consumerRegistry = Registries.create(true, true, consumerNotFoundHandler);
        return (SPEC)this;
    }

    protected abstract TARGET configure(EventBus var1, Environment var2);

    @Override
    protected final TARGET configure(Dispatcher dispatcher, Environment environment) {
        return this.configure(this.createReactor(dispatcher), environment);
    }

    private EventBus createReactor(Dispatcher dispatcher) {
        if (this.traceEventPath) {
            dispatcher = new TraceableDelegatingDispatcher(dispatcher);
        }
        return new EventBus(this.consumerRegistry != null ? this.consumerRegistry : this.createRegistry(), dispatcher, this.router != null ? this.router : this.createEventRouter(), this.dispatchErrorHandler, this.uncaughtErrorHandler);
    }

    private Router createEventRouter() {
        ConsumerFilteringRouter evr = new ConsumerFilteringRouter(this.eventFilter != null ? this.eventFilter : this.createFilter());
        if (this.traceEventPath) {
            return new TraceableDelegatingRouter(evr);
        }
        return evr;
    }

    private Filter createFilter() {
        AbstractFilter filter = EventRoutingStrategy.ROUND_ROBIN == this.eventRoutingStrategy ? new RoundRobinFilter() : (EventRoutingStrategy.RANDOM == this.eventRoutingStrategy ? new RandomFilter() : (EventRoutingStrategy.FIRST == this.eventRoutingStrategy ? new FirstFilter() : new PassThroughFilter()));
        return this.traceEventPath ? new TraceableDelegatingFilter(filter) : filter;
    }

    private Registry createRegistry() {
        return Registries.create();
    }

    protected static enum EventRoutingStrategy {
        BROADCAST,
        RANDOM,
        ROUND_ROBIN,
        FIRST;

    }
}

