/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import reactor.core.Disposable;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public final class LoggerUtils {
    @Nullable
    private static Logger testLogger;

    private LoggerUtils() {
    }

    public static Disposable useCurrentLoggersWithCapture() throws IllegalStateException {
        try {
            Field lfField = Loggers.class.getDeclaredField("LOGGER_FACTORY");
            lfField.setAccessible(true);
            Object originalFactory = lfField.get(Loggers.class);
            if (originalFactory instanceof CapturingFactory) {
                return (Disposable)originalFactory;
            }
            Method originalFactoryMethod = originalFactory.getClass().getMethod("apply", String.class);
            originalFactoryMethod.setAccessible(true);
            CapturingFactory capturingFactory = new CapturingFactory(originalFactory, originalFactoryMethod);
            Loggers.useCustomLoggers((Function)capturingFactory);
            return capturingFactory;
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new IllegalStateException("Could not install custom logger", e);
        }
    }

    public static void enableCaptureWith(Logger testLogger) {
        if (LoggerUtils.testLogger != null) {
            throw new IllegalStateException("A logger was already set, maybe from a previous run. Don't forget to call disableCapture()");
        }
        LoggerUtils.testLogger = testLogger;
    }

    public static void disableCapture() {
        testLogger = null;
    }

    private static class DivertingLogger
    implements Logger {
        private final Logger delegate;

        private DivertingLogger(Logger delegate) {
            this.delegate = delegate;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public boolean isTraceEnabled() {
            Logger logger = testLogger;
            return this.delegate.isTraceEnabled() || logger != null && logger.isTraceEnabled();
        }

        public void trace(String msg) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.trace(msg);
            }
            this.delegate.trace(msg);
        }

        public void trace(String format, Object ... arguments) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.trace(format, arguments);
            }
            this.delegate.trace(format, arguments);
        }

        public void trace(String msg, Throwable t) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.trace(msg, t);
            }
            this.delegate.trace(msg, t);
        }

        public boolean isDebugEnabled() {
            Logger logger = testLogger;
            return this.delegate.isDebugEnabled() || logger != null && logger.isDebugEnabled();
        }

        public void debug(String msg) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.debug(msg);
            }
            this.delegate.debug(msg);
        }

        public void debug(String format, Object ... arguments) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.debug(format, arguments);
            }
            this.delegate.debug(format, arguments);
        }

        public void debug(String msg, Throwable t) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.debug(msg, t);
            }
            this.delegate.debug(msg, t);
        }

        public boolean isInfoEnabled() {
            Logger logger = testLogger;
            return this.delegate.isInfoEnabled() || logger != null && logger.isInfoEnabled();
        }

        public void info(String msg) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.info(msg);
            }
            this.delegate.info(msg);
        }

        public void info(String format, Object ... arguments) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.info(format, arguments);
            }
            this.delegate.info(format, arguments);
        }

        public void info(String msg, Throwable t) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.info(msg, t);
            }
            this.delegate.info(msg, t);
        }

        public boolean isWarnEnabled() {
            Logger logger = testLogger;
            return this.delegate.isWarnEnabled() || logger != null && logger.isWarnEnabled();
        }

        public void warn(String msg) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.warn(msg);
            }
            this.delegate.warn(msg);
        }

        public void warn(String format, Object ... arguments) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.warn(format, arguments);
            }
            this.delegate.warn(format, arguments);
        }

        public void warn(String msg, Throwable t) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.warn(msg, t);
            }
            this.delegate.warn(msg, t);
        }

        public boolean isErrorEnabled() {
            Logger logger = testLogger;
            return this.delegate.isErrorEnabled() || logger != null && logger.isErrorEnabled();
        }

        public void error(String msg) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.error(msg);
            }
            this.delegate.error(msg);
        }

        public void error(String format, Object ... arguments) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.error(format, arguments);
            }
            this.delegate.error(format, arguments);
        }

        public void error(String msg, Throwable t) {
            Logger logger = testLogger;
            if (logger != null) {
                logger.error(msg, t);
            }
            this.delegate.error(msg, t);
        }
    }

    private static class CapturingFactory
    implements Function<String, Logger>,
    Disposable {
        private final Object originalFactory;
        private final Method originalFactoryMethod;

        private CapturingFactory(Object factory, Method method) {
            this.originalFactory = factory;
            this.originalFactoryMethod = method;
        }

        @Override
        public Logger apply(String category) {
            try {
                Logger original = (Logger)this.originalFactoryMethod.invoke(this.originalFactory, category);
                return new DivertingLogger(original);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public void dispose() {
            try {
                Field lfField = Loggers.class.getDeclaredField("LOGGER_FACTORY");
                lfField.setAccessible(true);
                Object o = lfField.get(Loggers.class);
                if (!(Loggers.getLogger(LoggerUtils.class) instanceof DivertingLogger)) {
                    throw new IllegalStateException("Expected the current factory to be " + this + ", found " + o + " instead");
                }
                lfField.set(Loggers.class, this.originalFactory);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

