/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;
import reactor.blockhound.BlockHoundRuntime;
import reactor.shaded.net.bytebuddy.agent.builder.AgentBuilder;
import reactor.shaded.net.bytebuddy.asm.Advice;
import reactor.shaded.net.bytebuddy.asm.AsmVisitorWrapper;
import reactor.shaded.net.bytebuddy.description.annotation.AnnotationDescription;
import reactor.shaded.net.bytebuddy.description.method.ParameterDescription;
import reactor.shaded.net.bytebuddy.description.type.TypeDescription;
import reactor.shaded.net.bytebuddy.dynamic.DynamicType;
import reactor.shaded.net.bytebuddy.utility.JavaModule;

class BlockingCallsByteBuddyTransformer
implements AgentBuilder.Transformer {
    private Map<String, Map<String, Set<String>>> blockingMethods;

    BlockingCallsByteBuddyTransformer(Map<String, Map<String, Set<String>>> blockingMethods) {
        this.blockingMethods = blockingMethods;
    }

    @Override
    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
        Map<String, Set<String>> methods = this.blockingMethods.get(typeDescription.getInternalName());
        if (methods == null) {
            return builder;
        }
        AsmVisitorWrapper.ForDeclaredMethods advice = Advice.withCustomMapping().bind(ModifiersArgument.Factory.INSTANCE).to(BlockingCallAdvice.class).on(method -> {
            Set descriptors = (Set)methods.get(method.getName());
            return descriptors != null && descriptors.contains(method.getDescriptor());
        });
        return builder.visit(advice);
    }

    static class BlockingCallAdvice {
        BlockingCallAdvice() {
        }

        @Advice.OnMethodEnter
        static void onEnter(@Advice.Origin(value="#t") String declaringType, @Advice.Origin(value="#m") String methodName, @ModifiersArgument int modifiers) {
            BlockHoundRuntime.checkBlocking(declaringType, methodName, modifiers);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    static @interface ModifiersArgument {

        public static enum Factory implements Advice.OffsetMapping.Factory<ModifiersArgument>
        {
            INSTANCE;


            @Override
            public Class<ModifiersArgument> getAnnotationType() {
                return ModifiersArgument.class;
            }

            @Override
            public Advice.OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<ModifiersArgument> annotation, Advice.OffsetMapping.Factory.AdviceType adviceType) {
                return (instrumentedType, instrumentedMethod, assigner, argumentHandler, sort) -> {
                    int modifiers = instrumentedMethod.getModifiers();
                    return Advice.OffsetMapping.Target.ForStackManipulation.of(modifiers);
                };
            }
        }
    }
}

