/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import io.qameta.allure.LabelAnnotation;
import io.qameta.allure.Link;
import io.qameta.allure.LinkAnnotation;
import io.qameta.allure.model.Label;
import io.qameta.allure.util.ResultsUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationUtils.class);
    private static final String VALUE_METHOD_NAME = "value";

    private AnnotationUtils() {
        throw new IllegalStateException("Do not instance");
    }

    public static Set<io.qameta.allure.model.Link> getLinks(AnnotatedElement annotatedElement) {
        return AnnotationUtils.getLinks(annotatedElement.getAnnotations());
    }

    public static Set<io.qameta.allure.model.Link> getLinks(Annotation ... annotations) {
        return AnnotationUtils.getLinks(Arrays.asList(annotations));
    }

    public static Set<io.qameta.allure.model.Link> getLinks(Collection<Annotation> annotations) {
        return AnnotationUtils.extractMetaAnnotations(LinkAnnotation.class, AnnotationUtils::extractLinks, annotations).collect(Collectors.toSet());
    }

    public static Set<Label> getLabels(AnnotatedElement annotatedElement) {
        return AnnotationUtils.getLabels(annotatedElement.getAnnotations());
    }

    public static Set<Label> getLabels(Annotation ... annotations) {
        return AnnotationUtils.getLabels(Arrays.asList(annotations));
    }

    public static Set<Label> getLabels(Collection<Annotation> annotations) {
        return AnnotationUtils.extractMetaAnnotations(LabelAnnotation.class, AnnotationUtils::extractLabels, annotations).collect(Collectors.toSet());
    }

    private static <T, U extends Annotation> Stream<T> extractMetaAnnotations(Class<U> annotationType, BiFunction<U, Annotation, Stream<T>> mapper, Collection<Annotation> candidates) {
        HashSet visited = new HashSet();
        return candidates.stream().flatMap(AnnotationUtils::extractRepeatable).flatMap(candidate -> AnnotationUtils.extractMetaAnnotations(annotationType, mapper, candidate, visited));
    }

    private static <T, U extends Annotation> Stream<T> extractMetaAnnotations(Class<U> annotationType, BiFunction<U, Annotation, Stream<T>> mapper, Annotation candidate, Set<Annotation> visited) {
        if (!AnnotationUtils.isInJavaLangAnnotationPackage(candidate.annotationType()) && visited.add(candidate)) {
            Stream children = Stream.of(candidate.annotationType().getAnnotations()).flatMap(AnnotationUtils::extractRepeatable).flatMap(annotation -> AnnotationUtils.extractMetaAnnotations(annotationType, mapper, annotation, visited));
            Stream current = Stream.of(candidate.annotationType().getAnnotationsByType(annotationType)).flatMap(marker -> (Stream)mapper.apply(marker, candidate));
            return Stream.concat(current, children);
        }
        return Stream.empty();
    }

    private static Stream<Label> extractLabels(LabelAnnotation m, Annotation annotation) {
        if (Objects.equals(m.value(), "$$$$$$$$__value__$$$$$$$$")) {
            return AnnotationUtils.callValueMethod(annotation).map(value -> ResultsUtils.createLabel(m.name(), value));
        }
        return Stream.of(ResultsUtils.createLabel(m.name(), m.value()));
    }

    private static Stream<io.qameta.allure.model.Link> extractLinks(LinkAnnotation m, Annotation annotation) {
        if (annotation instanceof Link) {
            return Stream.of(ResultsUtils.createLink((Link)annotation));
        }
        if (Objects.equals(m.value(), "$$$$$$$$__value__$$$$$$$$")) {
            return AnnotationUtils.callValueMethod(annotation).map(value -> ResultsUtils.createLink(value, null, m.url(), m.type()));
        }
        return Stream.of(ResultsUtils.createLink(m.value(), null, m.url(), m.type()));
    }

    private static Stream<String> callValueMethod(Annotation annotation) {
        try {
            Method method = annotation.annotationType().getMethod(VALUE_METHOD_NAME, new Class[0]);
            Object object = method.invoke((Object)annotation, new Object[0]);
            return AnnotationUtils.objectToStringStream(object);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Invalid annotation {}: marker annotations without value should contains value() method", (Object)annotation, (Object)e);
            return Stream.empty();
        }
    }

    private static Stream<String> objectToStringStream(Object object) {
        if (Objects.nonNull(object) && object.getClass().isArray()) {
            if (object instanceof Object[]) {
                return Stream.of((Object[])object).map(Objects::toString);
            }
            if (object instanceof long[]) {
                return Stream.of((long[])object).map(Objects::toString);
            }
            if (object instanceof short[]) {
                return Stream.of((short[])object).map(Objects::toString);
            }
            if (object instanceof int[]) {
                return Stream.of((int[])object).map(Objects::toString);
            }
            if (object instanceof char[]) {
                return Stream.of((char[])object).map(Objects::toString);
            }
            if (object instanceof double[]) {
                return Stream.of((double[])object).map(Objects::toString);
            }
            if (object instanceof float[]) {
                return Stream.of((float[])object).map(Objects::toString);
            }
            if (object instanceof boolean[]) {
                return Stream.of((boolean[])object).map(Objects::toString);
            }
            if (object instanceof byte[]) {
                return Stream.of((byte[])object).map(Objects::toString);
            }
        }
        return Stream.of(Objects.toString(object));
    }

    private static Stream<Annotation> extractRepeatable(Annotation annotation) {
        if (AnnotationUtils.isRepeatableWrapper(annotation)) {
            try {
                Method method = annotation.annotationType().getMethod(VALUE_METHOD_NAME, new Class[0]);
                return Stream.of((Annotation[])method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Could not extract repeatable annotation {}", (Object)annotation);
                return Stream.empty();
            }
        }
        return Stream.of(annotation);
    }

    private static boolean isRepeatableWrapper(Annotation annotation) {
        return Stream.of(annotation.annotationType().getDeclaredMethods()).filter(method -> VALUE_METHOD_NAME.equalsIgnoreCase(method.getName())).filter(method -> method.getReturnType().isArray()).anyMatch(method -> AnnotationUtils.isRepeatable(method.getReturnType().getComponentType()));
    }

    private static boolean isRepeatable(Class<?> annotationType) {
        return annotationType.isAnnotationPresent(Repeatable.class);
    }

    private static boolean isInJavaLangAnnotationPackage(Class<? extends Annotation> annotationType) {
        return annotationType != null && annotationType.getName().startsWith("java.lang.annotation");
    }
}

