/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.bucket4j.runtime;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.ConfigurationBuilder;
import io.quarkiverse.bucket4j.runtime.BucketPod;
import io.quarkiverse.bucket4j.runtime.BucketPodStorage;
import io.quarkiverse.bucket4j.runtime.MethodDescription;
import io.quarkiverse.bucket4j.runtime.RateLimiterRuntimeConfig;
import io.quarkus.runtime.annotations.Recorder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Recorder
public class BucketPodStorageRecorder {
    private final RateLimiterRuntimeConfig config;
    Map<MethodDescription, BucketPod> pods = new HashMap<MethodDescription, BucketPod>();

    public BucketPodStorageRecorder(RateLimiterRuntimeConfig config) {
        this.config = config;
    }

    private BucketPod getBucketPod(MethodDescription methodDescription, String key, String identityResolverClassName) {
        RateLimiterRuntimeConfig.Bucket bucketConfig = this.config.buckets().get(key);
        if (bucketConfig == null) {
            throw new IllegalStateException("missing limits config for " + key);
        }
        ConfigurationBuilder builder = BucketConfiguration.builder();
        for (RateLimiterRuntimeConfig.Limit limit : bucketConfig.limits()) {
            builder.addLimit(Bandwidth.builder().capacity((long)limit.permittedUses()).refillGreedy((long)limit.permittedUses(), limit.period()).build());
        }
        String id = bucketConfig.shared() != false ? key : key + methodDescription.hashCode();
        try {
            return new BucketPod(id, builder.build(), Thread.currentThread().getContextClassLoader().loadClass(Optional.ofNullable(identityResolverClassName).orElse(bucketConfig.identityResolver())));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public void registerMethod(MethodDescription description, String key, String identityResolverClassName) {
        this.pods.put(description, this.getBucketPod(description, key, identityResolverClassName));
    }

    public BucketPodStorage create() {
        return methodDescription -> this.pods.get(methodDescription);
    }
}

