/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.bucket4j.runtime;

import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.DurationConverter;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.List;
import java.util.Map;

@ConfigMapping(prefix="quarkus.rate-limiter")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface RateLimiterRuntimeConfig {
    @WithDefault(value="true")
    public boolean enabled();

    @WithDefault(value="1000")
    public int maxSize();

    @WithDefault(value="1H")
    @WithConverter(value=DurationConverter.class)
    public Duration keepAfterRefill();

    @ConfigDocMapKey(value="bucket-id")
    public Map<String, Bucket> buckets();

    @ConfigGroup
    public static interface Limit {
        public int permittedUses();

        @WithConverter(value=DurationConverter.class)
        public Duration period();
    }

    @ConfigGroup
    public static interface Bucket {
        @WithDefault(value="io.quarkiverse.bucket4j.runtime.resolver.ConstantResolver")
        public String identityResolver();

        public List<Limit> limits();

        @WithDefault(value="false")
        public Boolean shared();
    }
}

