/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.bucket4j.runtime;

import io.quarkiverse.bucket4j.runtime.BucketPod;
import io.quarkiverse.bucket4j.runtime.BucketPodStorage;
import io.quarkiverse.bucket4j.runtime.RateLimitException;
import io.quarkiverse.bucket4j.runtime.RateLimited;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.List;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@RateLimited
@Interceptor
@Priority(value=1000)
public class RateLimitedInterceptor {
    @Inject
    BucketPodStorage bucketPodStorage;
    @ConfigProperty(name="quarkus.rate-limiter.enabled")
    boolean enabled;

    @AroundInvoke
    Object around(InvocationContext context) throws Throwable {
        if (!this.enabled) {
            return context.proceed();
        }
        List<BucketPod> bucketPods = this.bucketPodStorage.getBucketPods(context.getMethod());
        long nanoWaitTime = 0L;
        for (BucketPod bucketPod : bucketPods) {
            long bucketNanoWaitTime = bucketPod.consumeAndReturnNanoWaitTime();
            if (bucketNanoWaitTime <= nanoWaitTime) continue;
            nanoWaitTime = bucketNanoWaitTime;
        }
        if (nanoWaitTime == 0L) {
            return context.proceed();
        }
        throw new RateLimitException(nanoWaitTime / 1000000L);
    }
}

