/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.bucket4j.runtime;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BandwidthBuilder;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.ConfigurationBuilder;
import io.quarkiverse.bucket4j.runtime.BucketPod;
import io.quarkiverse.bucket4j.runtime.BucketPodStorage;
import io.quarkiverse.bucket4j.runtime.MethodDescription;
import io.quarkiverse.bucket4j.runtime.RateLimiterRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Recorder
public class BucketPodStorageRecorder {
    private final RuntimeValue<RateLimiterRuntimeConfig> config;
    Map<MethodDescription, List<BucketPod>> pods = new HashMap<MethodDescription, List<BucketPod>>();

    public BucketPodStorageRecorder(RuntimeValue<RateLimiterRuntimeConfig> config) {
        this.config = config;
    }

    private BucketPod getBucketPod(MethodDescription methodDescription, String key, String identityResolverClassName) {
        RateLimiterRuntimeConfig.Bucket bucketConfig = ((RateLimiterRuntimeConfig)this.config.getValue()).buckets().get(key);
        if (bucketConfig == null) {
            throw new IllegalStateException("missing limits config for " + key);
        }
        ConfigurationBuilder builder = BucketConfiguration.builder();
        for (RateLimiterRuntimeConfig.Limit limit : bucketConfig.limits()) {
            builder.addLimit(this.createBandwidth(limit));
        }
        String id = bucketConfig.shared() != false ? key : key + methodDescription.hashCode();
        try {
            return new BucketPod(id, builder.build(), Thread.currentThread().getContextClassLoader().loadClass(Optional.ofNullable(identityResolverClassName).orElse(bucketConfig.identityResolver())));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private Bandwidth createBandwidth(RateLimiterRuntimeConfig.Limit limit) {
        BandwidthBuilder.BandwidthBuilderBuildStage stageBuilder;
        BandwidthBuilder.BandwidthBuilderRefillStage refillStage = Bandwidth.builder().capacity((long)limit.permittedUses());
        RateLimiterRuntimeConfig.Limit.RefillSpeed refillSpeed = limit.refillSpeed();
        if (refillSpeed == RateLimiterRuntimeConfig.Limit.RefillSpeed.GREEDY) {
            stageBuilder = refillStage.refillGreedy((long)limit.permittedUses(), limit.period());
        } else if (refillSpeed == RateLimiterRuntimeConfig.Limit.RefillSpeed.INTERVAL) {
            stageBuilder = refillStage.refillIntervally((long)limit.permittedUses(), limit.period());
        } else {
            throw new IllegalArgumentException();
        }
        if (limit.initialTokens().isPresent()) {
            stageBuilder = stageBuilder.initialTokens(limit.initialTokens().get().longValue());
        }
        return stageBuilder.build();
    }

    public void registerMethod(MethodDescription description, String key, String identityResolverClassName) {
        List bucketPods = this.pods.computeIfAbsent(description, k -> new ArrayList());
        bucketPods.add(this.getBucketPod(description, key, identityResolverClassName));
    }

    public BucketPodStorage create() {
        return methodDescription -> this.pods.get(methodDescription);
    }
}

