/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment;

import io.quarkiverse.cxf.CXFRecorder;
import io.quarkiverse.cxf.CXFServletInfos;
import io.quarkiverse.cxf.CxfFixedConfig;
import io.quarkiverse.cxf.deployment.CXFServletInfosBuildItem;
import io.quarkiverse.cxf.deployment.CxfBuildTimeConfig;
import io.quarkiverse.cxf.deployment.CxfDeploymentUtils;
import io.quarkiverse.cxf.deployment.CxfDotNames;
import io.quarkiverse.cxf.deployment.CxfEndpointImplementationBuildItem;
import io.quarkiverse.cxf.deployment.CxfRouteRegistrationRequestorBuildItem;
import io.quarkiverse.cxf.deployment.ServiceSeiBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.vertx.core.Handler;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class CxfEndpointImplementationProcessor {
    private static final Logger LOGGER = Logger.getLogger(CxfEndpointImplementationProcessor.class);

    @BuildStep
    void beanDefiningAnnotation(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotation) {
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(CxfDotNames.CXF_ENDPOINT_ANNOTATION, DotName.createSimple(ApplicationScoped.class), false));
    }

    @BuildStep
    void collectEndpoints(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<CxfEndpointImplementationBuildItem> endpointImplementations, BuildProducer<ServiceSeiBuildItem> serviceSeis, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        IndexView index = combinedIndexBuildItem.getIndex();
        TreeSet reflectives = new TreeSet();
        CxfDeploymentUtils.webServiceAnnotations(index).forEach(annotation -> {
            boolean hasWebServiceProviderAnnotation;
            boolean hasWebServiceAnnotation;
            ClassInfo wsClassInfo = annotation.target().asClass();
            if (CxfEndpointImplementationProcessor.isJaxwsEndpoint(wsClassInfo, index, true, hasWebServiceAnnotation = wsClassInfo.annotationsMap().containsKey(CxfDotNames.WEBSERVICE_ANNOTATION), hasWebServiceProviderAnnotation = wsClassInfo.annotationsMap().containsKey(CxfDotNames.WEBSERVICE_PROVIDER_ANNOTATION))) {
                CXFRecorder.BeanLookupStrategy beanLookupStrategy;
                String relPath;
                String impl = wsClassInfo.name().toString();
                AnnotationInstance cxfEndpointAnnotation = wsClassInfo.declaredAnnotation(CxfDotNames.CXF_ENDPOINT_ANNOTATION);
                if (cxfEndpointAnnotation != null) {
                    relPath = cxfEndpointAnnotation.value().asString();
                    beanLookupStrategy = CXFRecorder.BeanLookupStrategy.TYPE_WITH_CXFENDPOINT_ANNOTATION;
                } else {
                    relPath = null;
                    beanLookupStrategy = CXFRecorder.BeanLookupStrategy.TYPE;
                }
                this.submitImpl(endpointImplementations, serviceSeis, additionalBeans, reflectives, (AnnotationInstance)annotation, wsClassInfo, CxfDeploymentUtils.findSei(index, wsClassInfo), impl, hasWebServiceProviderAnnotation, relPath, beanLookupStrategy);
            } else if (Modifier.isInterface(wsClassInfo.flags())) {
                String cl = wsClassInfo.name().toString();
                try {
                    CxfDeploymentUtils.walkParents(Thread.currentThread().getContextClassLoader().loadClass(cl), reflectives::add);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not load " + cl + " at build time", e);
                }
            }
        });
        CxfDeploymentUtils.methodsWithCxfEndpointAnnotations(index).forEach(annotation -> {
            boolean hasWebServiceProviderAnnotation;
            MethodInfo methodInfo = annotation.target().asMethod();
            DotName returnType = methodInfo.returnType().name();
            String impl = returnType.toString();
            ClassInfo wsClassInfo = index.getClassByName(returnType);
            AnnotationInstance wsAnnot = wsClassInfo.declaredAnnotation(CxfDotNames.WEBSERVICE_ANNOTATION);
            boolean bl = hasWebServiceProviderAnnotation = wsAnnot != null;
            if (wsAnnot == null && (wsAnnot = wsClassInfo.declaredAnnotation(CxfDotNames.WEBSERVICE_PROVIDER_ANNOTATION)) == null) {
                throw new IllegalStateException("The return type '" + impl + "' of method " + methodInfo.toString() + " must be annotated with either " + String.valueOf(CxfDotNames.WEBSERVICE_ANNOTATION) + " or " + String.valueOf(CxfDotNames.WEBSERVICE_PROVIDER_ANNOTATION));
            }
            this.submitImpl(endpointImplementations, serviceSeis, additionalBeans, reflectives, wsAnnot, wsClassInfo, CxfDeploymentUtils.findSei(index, wsClassInfo), impl, hasWebServiceProviderAnnotation, annotation.value().asString(), CXFRecorder.BeanLookupStrategy.METHOD_WITH_CXFENDPOINT_ANNOTATION);
        });
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])reflectives.toArray(new String[0])).methods().fields().build());
    }

    private void submitImpl(BuildProducer<CxfEndpointImplementationBuildItem> endpointImplementations, BuildProducer<ServiceSeiBuildItem> serviceSeis, BuildProducer<AdditionalBeanBuildItem> additionalBeans, Set<String> reflectives, AnnotationInstance annotation, ClassInfo wsClassInfo, String sei, String impl, boolean hasWebServiceProviderAnnotation, String relativePathFromCxfEndpointAnnotation, CXFRecorder.BeanLookupStrategy beanLookupStrategy) {
        try {
            CxfDeploymentUtils.walkParents(Thread.currentThread().getContextClassLoader().loadClass(impl), reflectives::add);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load " + impl + " at build time", e);
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)impl));
        String wsNamespace = Optional.ofNullable(annotation.value("targetNamespace")).map(AnnotationValue::asString).orElseGet(() -> CxfDeploymentUtils.getNameSpaceFromClassInfo(wsClassInfo));
        String wsName = Optional.ofNullable(annotation.value("serviceName")).map(AnnotationValue::asString).orElse(sei.contains(".") ? sei.substring(sei.lastIndexOf(46) + 1) : sei);
        String soapBinding = Optional.ofNullable(wsClassInfo.declaredAnnotation(CxfDotNames.BINDING_TYPE_ANNOTATION)).map(bindingType -> bindingType.value().asString()).orElse("http://schemas.xmlsoap.org/wsdl/soap/http");
        endpointImplementations.produce((BuildItem)new CxfEndpointImplementationBuildItem(sei, impl, soapBinding, wsNamespace, wsName, hasWebServiceProviderAnnotation, relativePathFromCxfEndpointAnnotation, beanLookupStrategy));
        serviceSeis.produce((BuildItem)new ServiceSeiBuildItem(impl));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    CXFServletInfosBuildItem startRoute(CXFRecorder recorder, BuildProducer<RouteBuildItem> routes, BeanContainerBuildItem beanContainer, List<CxfEndpointImplementationBuildItem> cxfEndpoints, List<CxfRouteRegistrationRequestorBuildItem> cxfRouteRegistrationRequestors, VertxHttpBuildTimeConfig httpBuildTimeConfig, CxfBuildTimeConfig cxfBuildTimeConfig, CxfFixedConfig fixedConfig) {
        RuntimeValue infos = recorder.createInfos(fixedConfig.path(), httpBuildTimeConfig.rootPath());
        List requestors = cxfRouteRegistrationRequestors.stream().map(CxfRouteRegistrationRequestorBuildItem::getRequestorName).collect(Collectors.toList());
        if (!cxfEndpoints.isEmpty()) {
            RuntimeValue implementorToCfgMap = recorder.implementorToCfgMap();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            for (CxfEndpointImplementationBuildItem cxfWebService : cxfEndpoints) {
                try {
                    recorder.addCxfServletInfo(infos, implementorToCfgMap, fixedConfig.path(), cl.loadClass(cxfWebService.getSei()), cxfWebService.getWsName(), cxfWebService.getWsNamespace(), cxfWebService.getSoapBinding(), cl.loadClass(cxfWebService.getImplementor()), Boolean.valueOf(cxfWebService.isProvider()), cxfWebService.getRelativePath(), cxfWebService.getBeanLookupStrategy());
                    requestors.add(cxfWebService.getImplementor());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!requestors.isEmpty()) {
            Handler handler = recorder.initServer(infos, beanContainer.getValue(), fixedConfig);
            String mappingPath = CxfEndpointImplementationProcessor.getMappingPath(fixedConfig.path());
            LOGGER.infof("Mapping a Vert.x handler for CXF to %s as requested by %s", (Object)mappingPath, requestors);
            routes.produce((BuildItem)RouteBuildItem.builder().route(mappingPath).handler(handler).handlerType(HandlerType.BLOCKING).build());
        } else {
            LOGGER.debug((Object)"Not registering a Vert.x handler for CXF as no WS endpoints were found at build time and no other extension requested it");
        }
        return new CXFServletInfosBuildItem((RuntimeValue<CXFServletInfos>)infos);
    }

    private static String getMappingPath(String path) {
        String mappingPath = path.endsWith("/") ? path + "*" : path + "/*";
        return mappingPath;
    }

    private static boolean isJaxwsEndpoint(ClassInfo clazz, IndexView index, boolean log, boolean hasWebServiceAnnotation, boolean hasWebServiceProviderAnnotation) {
        short flags = clazz.flags();
        if (Modifier.isInterface(flags)) {
            return false;
        }
        if (Modifier.isAbstract(flags)) {
            return false;
        }
        if (!Modifier.isPublic(flags)) {
            return false;
        }
        if (CxfEndpointImplementationProcessor.isJaxwsService(clazz, index)) {
            return false;
        }
        if (!hasWebServiceAnnotation && !hasWebServiceProviderAnnotation) {
            return false;
        }
        if (hasWebServiceAnnotation && hasWebServiceProviderAnnotation) {
            if (log) {
                LOGGER.warnf("[JAXWS 2.2 spec, section 7.7] The @WebService and @WebServiceProvider annotations are mutually exclusive - %s won't be considered as a webservice endpoint, since it doesn't meet that requirement", (Object)clazz.name().toString());
            }
            return false;
        }
        if (Modifier.isFinal(flags)) {
            if (log) {
                LOGGER.warnf("WebService endpoint class cannot be final - %s won't be considered as a webservice endpoint", (Object)clazz.name().toString());
            }
            return false;
        }
        return true;
    }

    private static boolean isJaxwsService(ClassInfo current, IndexView index) {
        ClassInfo tmp = current;
        while (tmp != null) {
            DotName superName = tmp.superName();
            if (CxfDotNames.JAXWS_SERVICE_CLASS.equals((Object)superName)) {
                return true;
            }
            tmp = index.getClassByName(superName);
        }
        return false;
    }
}

