/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkus.tls.TlsConfiguration;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import java.security.KeyStore;
import java.util.Optional;
import javax.net.ssl.SSLContext;

public class CxfTlsConfiguration
implements TlsConfiguration {
    private final TrustOptions trustOptions;
    private final KeyStore trustStore;
    private final KeyCertOptions keyStoreOptions;
    private final KeyStore keyStore;
    private final String name;

    public CxfTlsConfiguration(KeyCertOptions keyStoreOptions, KeyStore keyStore, TrustOptions trustOptions, KeyStore trustStore, String name) {
        this.keyStoreOptions = keyStoreOptions;
        this.keyStore = keyStore;
        this.trustOptions = trustOptions;
        this.trustStore = trustStore;
        this.name = name;
    }

    public KeyCertOptions getKeyStoreOptions() {
        return this.keyStoreOptions;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public TrustOptions getTrustStoreOptions() {
        return this.trustOptions;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public SSLContext createSSLContext() throws Exception {
        throw new UnsupportedOperationException(this.getClass().getName() + ".createSSLContext() is not supported");
    }

    public synchronized SSLOptions getSSLOptions() {
        SSLOptions options = new SSLOptions();
        options.setKeyCertOptions(this.getKeyStoreOptions());
        options.setTrustOptions(this.getTrustStoreOptions());
        return options;
    }

    public boolean isTrustAll() {
        return false;
    }

    public Optional<String> getHostnameVerificationAlgorithm() {
        return Optional.empty();
    }

    public boolean usesSni() {
        return false;
    }

    public boolean reload() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".reload() is not supported");
    }

    public String getName() {
        return this.name;
    }
}

