/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.StacklessRejectedExecutionException;
import io.quarkus.runtime.BlockingOperationControl;
import io.vertx.core.Vertx;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Binding;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.Response;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.jboss.logging.Logger;

public class QuarkusJaxWsProxyFactoryBean
extends JaxWsProxyFactoryBean {
    private static final Logger log = Logger.getLogger(QuarkusJaxWsProxyFactoryBean.class);
    private final Class<?>[] additionalImplementingClasses;
    private final Vertx vertx;
    private final long workerDispatchTimeout;

    public QuarkusJaxWsProxyFactoryBean(ClientFactoryBean fact, Vertx vertx, long workerDispatchTimeout, Class<?> ... additionalImplementingClasses) {
        super(fact);
        this.vertx = vertx;
        this.workerDispatchTimeout = workerDispatchTimeout;
        this.additionalImplementingClasses = additionalImplementingClasses;
    }

    protected Class<?>[] getImplementingClasses() {
        Class cls = this.getClientFactoryBean().getServiceClass();
        Class[] result = new Class[this.additionalImplementingClasses.length + 1];
        result[0] = cls;
        System.arraycopy(this.additionalImplementingClasses, 0, result, 1, this.additionalImplementingClasses.length);
        return result;
    }

    protected ClientProxy clientClientProxy(Client c) {
        return new QuarkusJaxWsClientProxy(this.vertx, (JaxWsClientProxy)super.clientClientProxy(c), this.workerDispatchTimeout);
    }

    public static class QuarkusJaxWsClientProxy
    extends ClientProxy
    implements BindingProvider {
        private final JaxWsClientProxy delegate;
        private final Vertx vertx;
        private final long workerDispatchTimeout;

        public QuarkusJaxWsClientProxy(Vertx vertx, JaxWsClientProxy delegate, long workerDispatchTimeout) {
            super(delegate.getClient());
            this.vertx = vertx;
            this.delegate = delegate;
            this.workerDispatchTimeout = workerDispatchTimeout;
        }

        public Object invoke(final Object proxy, final Method method, Object[] args) throws Throwable {
            boolean isAsync = this.isAsync(method);
            if (isAsync && !BlockingOperationControl.isBlockingAllowed()) {
                long timerId;
                AtomicBoolean completed;
                Object newAsyncHandler;
                Object[] newArgs;
                final CompletableFuture result = new CompletableFuture();
                int len = args.length;
                if (len > 0 && args[len - 1] instanceof AsyncHandler) {
                    final AsyncHandler jaxWsHandler = (AsyncHandler)args[len - 1];
                    newArgs = new Object[len];
                    System.arraycopy(args, 0, newArgs, 0, len);
                    newAsyncHandler = new AsyncHandler<Object>(){

                        public void handleResponse(Response<Object> res) {
                            try {
                                jaxWsHandler.handleResponse(res);
                            }
                            finally {
                                result.complete(res);
                            }
                        }
                    };
                    newArgs[len - 1] = newAsyncHandler;
                } else {
                    newArgs = new Object[len + 1];
                    System.arraycopy(args, 0, newArgs, 0, len);
                    newAsyncHandler = new AsyncHandler<Object>(){

                        public void handleResponse(Response<Object> res) {
                            result.complete(res);
                        }
                    };
                    newArgs[len] = newAsyncHandler;
                }
                if (this.workerDispatchTimeout > 0L) {
                    completed = new AtomicBoolean(false);
                    timerId = this.vertx.setTimer(this.workerDispatchTimeout, arg_0 -> this.lambda$invoke$0(completed, (AsyncHandler)newAsyncHandler, arg_0));
                    log.debugf("Created timer %d with timeout %d", timerId, this.workerDispatchTimeout);
                } else {
                    completed = null;
                    timerId = -1L;
                }
                this.vertx.executeBlocking((Callable)new Callable<Object>(){

                    @Override
                    public Void call() throws Exception {
                        if (completed != null) {
                            vertx.cancelTimer(timerId);
                            boolean alive = completed.compareAndSet(false, true);
                            if (log.isDebugEnabled()) {
                                log.debugf("Scheduled on a worker thread for timer %d: %s", timerId, (Object)(alive ? "alive" : "dead"));
                            }
                            if (!alive) {
                                return null;
                            }
                        }
                        try {
                            delegate.invoke(proxy, method, newArgs);
                            return null;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                        catch (Exception e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw new Exception(e);
                        }
                    }
                }).onFailure(arg_0 -> QuarkusJaxWsClientProxy.lambda$invoke$1((AsyncHandler)newAsyncHandler, arg_0));
                return new QuarkusJaxWsResponse(result);
            }
            return this.delegate.invoke(proxy, method, args);
        }

        boolean isAsync(Method m) {
            return m.getName().endsWith("Async") && (Future.class.equals(m.getReturnType()) || Response.class.equals(m.getReturnType()));
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public Object invokeSync(Method method, BindingOperationInfo oi, Object[] params) throws Exception {
            return this.delegate.invokeSync(method, oi, params);
        }

        public Map<String, Object> getRequestContext() {
            return this.delegate.getRequestContext();
        }

        public Map<String, Object> getResponseContext() {
            return this.delegate.getResponseContext();
        }

        public Client getClient() {
            return this.delegate.getClient();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public Binding getBinding() {
            return this.delegate.getBinding();
        }

        public EndpointReference getEndpointReference() {
            return this.delegate.getEndpointReference();
        }

        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
            return (T)this.delegate.getEndpointReference(clazz);
        }

        private static /* synthetic */ void lambda$invoke$1(AsyncHandler newAsyncHandler, Throwable e) {
            newAsyncHandler.handleResponse(new QuarkusJaxWsFailedResponse(e));
        }

        private /* synthetic */ void lambda$invoke$0(AtomicBoolean completed, AsyncHandler newAsyncHandler, Long id) {
            boolean shouldTimeout = completed.compareAndSet(false, true);
            log.debugf("Timer %d will timeout: %s", (Object)id, (Object)shouldTimeout);
            if (shouldTimeout) {
                newAsyncHandler.handleResponse(new QuarkusJaxWsFailedResponse(StacklessRejectedExecutionException.workerDispatchTimeout(this.workerDispatchTimeout)));
            }
        }

        static class QuarkusJaxWsResponse<T>
        implements Response<T> {
            final CompletableFuture<Response<T>> delegate;

            public QuarkusJaxWsResponse(CompletableFuture<Response<T>> delegate) {
                this.delegate = delegate;
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                return this.delegate.cancel(mayInterruptIfRunning);
            }

            public boolean isCancelled() {
                return this.delegate.isCancelled();
            }

            public boolean isDone() {
                return this.delegate.isDone();
            }

            public T get() throws InterruptedException, ExecutionException {
                return (T)this.delegate.get().get();
            }

            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return (T)this.delegate.get(timeout, unit).get();
            }

            public Map<String, Object> getContext() {
                try {
                    return this.delegate.get().getContext();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        static class QuarkusJaxWsFailedResponse<T>
        implements Response<T> {
            private final CompletableFuture<T> delegate;

            public QuarkusJaxWsFailedResponse(Throwable e) {
                this.delegate = CompletableFuture.failedFuture(e);
            }

            public Map<String, Object> getContext() {
                return null;
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                return this.delegate.cancel(mayInterruptIfRunning);
            }

            public boolean isCancelled() {
                return this.delegate.isCancelled();
            }

            public boolean isDone() {
                return this.delegate.isDone();
            }

            public T get() throws InterruptedException, ExecutionException {
                return this.delegate.get();
            }

            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.delegate.get(timeout, unit);
            }
        }
    }
}

