/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.mutiny;

import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.StacklessRejectedExecutionException;
import io.quarkiverse.cxf.mutiny.SucceededResponse;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.runtime.BlockingOperationControl;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.vertx.core.Vertx;
import jakarta.xml.ws.AsyncHandler;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class CxfMutinyUtils {
    private static final Logger log = Logger.getLogger(CxfMutinyUtils.class);

    public static <T> Uni<T> toUni(Consumer<AsyncHandler<T>> subscriptionConsumer) {
        return new WsAsyncHandlerUni<Object, Object>(subscriptionConsumer, (payload, context) -> payload);
    }

    public static <T> Uni<SucceededResponse<T>> toResponseUni(Consumer<AsyncHandler<T>> subscriptionConsumer) {
        return new WsAsyncHandlerUni<SucceededResponse, Object>(subscriptionConsumer, (payload, context) -> new SucceededResponse<Object>(payload, (Map<String, Object>)context));
    }

    static class WsAsyncHandlerUni<T, P>
    extends AbstractUni<T>
    implements Uni<T> {
        private final Consumer<AsyncHandler<P>> subscriptionConsumer;
        private final BiFunction<P, Map<String, Object>, T> mapper;

        public WsAsyncHandlerUni(Consumer<AsyncHandler<P>> subscriptionConsumer, BiFunction<P, Map<String, Object>, T> mapper) {
            this.subscriptionConsumer = Infrastructure.decorate(subscriptionConsumer);
            this.mapper = mapper;
        }

        public void subscribe(UniSubscriber<? super T> downstream) {
            AtomicBoolean terminated = new AtomicBoolean();
            downstream.onSubscribe(() -> terminated.set(true));
            if (!terminated.get()) {
                if (!BlockingOperationControl.isBlockingAllowed()) {
                    CancelTimer cancelTimer;
                    ArcContainer container = Arc.container();
                    long workerDispatchTimeout = ((CxfConfig)container.instance(CxfConfig.class, new Annotation[0]).get()).client().workerDispatchTimeout();
                    Vertx vertx = (Vertx)container.instance(Vertx.class, new Annotation[0]).get();
                    if (workerDispatchTimeout > 0L) {
                        long timerId = vertx.setTimer(workerDispatchTimeout, id -> {
                            boolean shouldTimeout = !terminated.getAndSet(true);
                            log.debugf("Timer %d will timeout: %s", id, (Object)shouldTimeout);
                            if (shouldTimeout) {
                                downstream.onFailure((Throwable)StacklessRejectedExecutionException.workerDispatchTimeout(workerDispatchTimeout));
                            }
                        });
                        log.debugf("Created timer %d with timeout %d", timerId, workerDispatchTimeout);
                        cancelTimer = new CancelTimer(vertx, timerId);
                    } else {
                        cancelTimer = null;
                    }
                    vertx.executeBlocking(() -> {
                        if (!terminated.get()) {
                            this.subscribeIntenal(downstream, terminated, cancelTimer);
                        }
                        return null;
                    }).onFailure(e -> {
                        if (!terminated.getAndSet(true)) {
                            downstream.onFailure(e);
                        }
                    });
                } else {
                    this.subscribeIntenal(downstream, terminated, null);
                }
            }
        }

        private void subscribeIntenal(UniSubscriber<? super T> downstream, AtomicBoolean terminated, Runnable cancelTimer) {
            block2: {
                try {
                    this.subscriptionConsumer.accept(response -> {
                        boolean alive;
                        if (cancelTimer != null) {
                            cancelTimer.run();
                        }
                        boolean bl = alive = !terminated.getAndSet(true);
                        if (log.isDebugEnabled()) {
                            log.debugf("Scheduled on a worker thread for timer %d: %s", (Object)cancelTimer, (Object)(alive ? "alive" : "dead"));
                        }
                        if (alive) {
                            try {
                                downstream.onItem(this.mapper.apply(response.get(), response.getContext()));
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                downstream.onFailure((Throwable)e);
                            }
                            catch (ExecutionException e) {
                                downstream.onFailure(e.getCause());
                            }
                            catch (Exception e) {
                                downstream.onFailure((Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (terminated.getAndSet(true)) break block2;
                    downstream.onFailure((Throwable)e);
                }
            }
        }
    }

    private record CancelTimer(Vertx vertx, long timerId) implements Runnable
    {
        @Override
        public void run() {
            if (this.timerId >= 0L) {
                this.vertx.cancelTimer(this.timerId);
            }
        }

        @Override
        public String toString() {
            return String.valueOf(this.timerId);
        }
    }
}

