/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.quarkiverse.cxf.transport.VertxDestination;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.DestinationRegistryImpl;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;
import org.jboss.logging.Logger;

public class VertxDestinationFactory
extends HTTPTransportFactory
implements WSDLEndpointFactory {
    private static final Logger LOGGER = Logger.getLogger(VertxDestinationFactory.class);
    private static final DestinationRegistry registry = new DestinationRegistryImpl();
    private final SoapTransportFactory soapTransportFactory = new SoapTransportFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetRegistry() {
        DestinationRegistry destinationRegistry = registry;
        synchronized (destinationRegistry) {
            for (String path : new ArrayList(registry.getDestinationsPaths())) {
                registry.removeDestination(path);
            }
        }
    }

    public VertxDestinationFactory() {
        super(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination(EndpointInfo endpointInfo, Bus bus) throws IOException {
        if (endpointInfo == null) {
            throw new IllegalArgumentException("EndpointInfo cannot be null");
        }
        DestinationRegistry destinationRegistry = registry;
        synchronized (destinationRegistry) {
            String endpointAddress = endpointInfo.getAddress();
            LOGGER.debug((Object)String.format("Looking for destination for address %s...", endpointAddress));
            Object d = registry.getDestinationForPath(endpointInfo.getAddress());
            if (d == null) {
                LOGGER.debug((Object)String.format("Creating VertxDestination for address %s...", endpointAddress));
                d = new VertxDestination(endpointInfo, bus, registry);
                registry.addDestination(d);
                d.finalizeConfig();
            }
            LOGGER.debug((Object)String.format("Destination for address %s is %s", endpointAddress, d));
            return d;
        }
    }

    public void createPortExtensors(Bus b, EndpointInfo ei, Service service) {
        this.soapTransportFactory.createPortExtensors(b, ei, service);
    }

    public EndpointInfo createEndpointInfo(Bus bus, ServiceInfo serviceInfo, BindingInfo b, List<?> ees) {
        return this.soapTransportFactory.createEndpointInfo(bus, serviceInfo, b, ees);
    }
}

