/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.vertx.http.client;

import io.vertx.core.Closeable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.file.FileSystem;
import io.vertx.core.impl.ContextInternal;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;

public class TempStore {
    private static final Logger log = Logger.getLogger(TempStore.class);
    private static final long MIN_DELAY = 2000L;
    public static final String CONTEXT_KEY = TempStore.class.getName();
    private final ContextInternal ctx;
    private final Path directory;
    private final long gcDelayMs;
    private final long fileDelayMs;
    private final boolean gcOnShutDown;
    private Future<InitializedTempStore> initializedTempStore;

    public static Future<InitializedTempStore> fromContext(Context ctx, Optional<String> tempDir, long fileDelayMs, boolean gcOnShutDown) {
        TempStore.validateDelayMs(fileDelayMs, "quarkus.cxf.retransmit-cache.gc-delay");
        return TempStore.fromContext(ctx, tempDir, fileDelayMs >> 1, fileDelayMs, gcOnShutDown);
    }

    public static Future<InitializedTempStore> fromContext(Context ctx, Optional<String> tempDir, long gcDelayMs, long fileDelayMs, boolean gcOnShutDown) {
        ContextInternal ctxi = (ContextInternal)ctx;
        return ((TempStore)ctxi.contextData().computeIfAbsent(CONTEXT_KEY, k -> new TempStore(ctxi, Path.of(tempDir.orElse(System.getProperty("java.io.tmpdir")), new String[0]), gcDelayMs, fileDelayMs, gcOnShutDown))).initializeIfNeeded();
    }

    TempStore(ContextInternal ctx, Path directory, long gcDelayMs, long fileDelayMs, boolean gcOnShutDown) {
        this.ctx = ctx;
        this.directory = directory;
        this.gcDelayMs = gcDelayMs;
        this.fileDelayMs = fileDelayMs;
        this.gcOnShutDown = gcOnShutDown;
    }

    public static long validateDelayMs(long delayMs, String label) {
        if (delayMs < 2000L && delayMs != 0L) {
            throw new IllegalArgumentException("The value of " + label + " must be >= 2000 or 0 to disable regular deletion of stale temporary files");
        }
        return delayMs;
    }

    Future<InitializedTempStore> initializeIfNeeded() {
        if (this.initializedTempStore != null) {
            return this.initializedTempStore;
        }
        FileSystem fs = this.ctx.owner().fileSystem();
        return fs.exists(this.directory.toString()).compose(exists -> {
            if (this.initializedTempStore != null) {
                return this.initializedTempStore;
            }
            if (!exists.booleanValue()) {
                this.initializedTempStore = fs.mkdirs(this.directory.toString()).compose(dir -> Future.succeededFuture((Object)new InitializedTempStore(this.ctx, this.directory, this.gcDelayMs, this.fileDelayMs, this.gcOnShutDown)));
                return this.initializedTempStore;
            }
            this.initializedTempStore = Future.succeededFuture((Object)new InitializedTempStore(this.ctx, this.directory, this.gcDelayMs, this.fileDelayMs, this.gcOnShutDown));
            return this.initializedTempStore;
        });
    }

    public static class InitializedTempStore
    implements Closeable {
        private final ContextInternal ctx;
        private final Path directory;
        private final long gcDelayMs;
        private final long fileDelayMs;
        private final boolean gcOnShutDown;
        private final String prefix;
        private final String threadName;
        private int counter = 0;
        private long timerId = -1L;
        private List<TempPath> tempFiles = new CopyOnWriteArrayList<TempPath>();

        InitializedTempStore(ContextInternal ctx, Path directory, long gcDelayMs, long fileDelayMs, boolean gcOnShutDown) {
            ctx.addCloseHook((Closeable)this);
            this.ctx = ctx;
            this.directory = directory;
            this.gcDelayMs = gcDelayMs;
            this.fileDelayMs = fileDelayMs;
            this.gcOnShutDown = gcOnShutDown;
            String threadName = Thread.currentThread().getName();
            String shortThreadName = threadName.replace("vert.x-eventloop-thread-", "evtloop-");
            this.prefix = "qcxf-TempStore-" + ProcessHandle.current().pid() + "-" + shortThreadName + "-";
            boolean asserting = false;
            if (!$assertionsDisabled) {
                asserting = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            this.threadName = asserting ? threadName : null;
            log.debugf("Initialized a new TempStore %s/%s*", (Object)directory, (Object)this.prefix);
        }

        public Path getDirectory() {
            return this.directory;
        }

        public Future<TempPath> newTempPath() {
            assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
            if (this.tempFiles != null) {
                TempPath newPath = new TempPath(this.directory.resolve(this.prefix + this.counter++), System.currentTimeMillis() + this.fileDelayMs);
                this.tempFiles.add(newPath);
                if (this.fileDelayMs >= 2000L && this.timerId < 0L) {
                    this.timerId = this.ctx.owner().setPeriodic(this.gcDelayMs, tid -> this.gc());
                }
                log.debugf("Created new temporary path %s", (Object)newPath);
                return Future.succeededFuture((Object)newPath);
            }
            return Future.failedFuture((String)"Cannot get new TempPath: TempStore closed already");
        }

        public void gc() {
            if (this.tempFiles != null) {
                this.ctx.runOnContext(v -> {
                    assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
                    if (this.tempFiles != null) {
                        this.delete(new ArrayList<TempPath>(this.tempFiles), System.currentTimeMillis()).onSuccess(dels -> log.debugf("Gc'd %d temporary files in TempStore %s/%s*", dels.size(), (Object)this.directory, (Object)this.prefix)).onFailure(e -> log.errorf(e, "Could not gc some temporary files in TempStore %s/%s*", (Object)this.directory, (Object)this.prefix));
                    }
                });
            }
        }

        public void close(Promise<Void> completion) {
            if (this.timerId >= 0L) {
                this.ctx.owner().cancelTimer(this.timerId);
                this.timerId = -1L;
            }
            this.ctx.contextData().remove(CONTEXT_KEY);
            if (this.tempFiles != null) {
                List<TempPath> tempFiles = this.tempFiles;
                this.tempFiles = null;
                if (!this.gcOnShutDown) {
                    log.debugf("Skipping deletion of %d temporary files in TempStore %s/%s* on close", tempFiles.size(), (Object)this.directory, (Object)this.prefix);
                    completion.complete();
                    return;
                }
                this.delete(tempFiles, 0L).onSuccess(dels -> {
                    log.debugf("Deleted %d files on close in TempStore %s/%s*", dels.size(), (Object)this.directory, (Object)this.prefix);
                    completion.complete();
                }).onFailure(e -> {
                    log.errorf(e, "Could not delete some temporary files on close in TempStore %s/%s*", (Object)this.directory, (Object)this.prefix);
                    completion.fail(e);
                });
            } else {
                log.debugf("Nothing to cleanup on close in TempStore %s/%s*", (Object)this.directory, (Object)this.prefix);
                completion.complete();
            }
        }

        CompositeFuture delete(List<TempPath> tempFiles, long currentTimeMillis) {
            ArrayList<Future> deletions = new ArrayList<Future>(tempFiles.size());
            for (TempPath path : tempFiles) {
                if (path.gcTime < currentTimeMillis) continue;
                deletions.add(this.ctx.owner().fileSystem().exists(path.path.toString()).compose(exists -> {
                    if (exists.booleanValue()) {
                        return this.ctx.owner().fileSystem().delete(path.path.toString()).andThen(ar -> {
                            if (ar.succeeded()) {
                                log.debugf("Deleted temporary file %s", (Object)path.path);
                            } else {
                                log.warnf(ar.cause(), "Could not delete temporary file %s", (Object)path.path);
                            }
                        });
                    }
                    log.debugf("Temporary file %s did not exist when attempting to delete it", (Object)path.path);
                    return Future.succeededFuture();
                }));
            }
            return Future.all(deletions);
        }

        public class TempPath {
            private final Path path;
            private final long gcTime;

            public TempPath(Path path, long gcTime) {
                this.path = path;
                this.gcTime = gcTime;
            }

            public Future<Void> discard() {
                String p = this.path.toString();
                FileSystem fs = InitializedTempStore.this.ctx.owner().fileSystem();
                return fs.exists(p).compose(exists -> {
                    if (exists.booleanValue()) {
                        return fs.delete(p).andThen(ar -> {
                            if (ar.succeeded()) {
                                log.debugf("Deleted temporary file %s", (Object)p);
                            } else {
                                log.warnf(ar.cause(), "Could not delete temporary file %s", (Object)p);
                            }
                        });
                    }
                    log.debugf("Temporary file %s did not exist when attempting to delete it", (Object)p);
                    return Future.succeededFuture();
                }).andThen(f -> {
                    List<TempPath> tfs = InitializedTempStore.this.tempFiles;
                    if (tfs != null) {
                        tfs.remove(this);
                    }
                });
            }

            public Path getPath() {
                return this.path;
            }

            public String toString() {
                return String.valueOf(this.path) + "@" + this.gcTime;
            }
        }
    }
}

